/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.statet.ecommons.text.IIndentSettings;
import org.eclipse.statet.ecommons.text.IndentUtil;
import org.eclipse.statet.ecommons.text.TextUtil;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.r.core.IRCoreAccess;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.ui.texteditor.IUpdate;

public class RDoubleCommentAction
extends Action
implements IUpdate {
    public static final String ACTION_ID = "org.eclipse.statet.r.actions.AddDoubleComment";
    private final ISourceEditor fEditor;
    private final IRCoreAccess fCore;

    public RDoubleCommentAction(ISourceEditor editor, IRCoreAccess core) {
        this.fEditor = editor;
        this.fCore = core;
        this.setId(ACTION_ID);
        this.setActionDefinitionId("org.eclipse.statet.ltk.commands.AddDocComment");
        this.update();
    }

    public void update() {
        this.setEnabled(this.fEditor.isEditable(false));
    }

    public void run() {
        if (!this.fEditor.isEditable(true)) {
            return;
        }
        try {
            this.addComment();
        }
        catch (BadLocationException e) {
            RUIPlugin.logError(100, "An error occurred while running RDoubleClickAction.", e);
        }
    }

    private void addComment() throws BadLocationException {
        SourceViewer sourceViewer = this.fEditor.getViewer();
        final IDocument document = sourceViewer.getDocument();
        ITextSelection selection = (ITextSelection)sourceViewer.getSelectionProvider().getSelection();
        int offset = selection.getOffset();
        RHeuristicTokenScanner scanner = RHeuristicTokenScanner.create((DocContentSections)this.fEditor.getDocumentContentInfo());
        scanner.configure(document);
        if (selection.getLength() == 0 && scanner.isBlankLine(selection.getOffset())) {
            document.replace(offset, 0, "## ");
            sourceViewer.setSelectedRange(offset + 3, 0);
            sourceViewer.revealRange(offset + 3, 0);
            return;
        }
        IRegion textBlock = TextUtil.getBlock((IDocument)document, (int)selection.getOffset(), (int)(selection.getOffset() + selection.getLength()));
        final IndentUtil util = new IndentUtil(document, (IIndentSettings)this.fCore.getRCodeStyle());
        IDocumentExtension4 doc4 = null;
        DocumentRewriteSession rewriteSession = null;
        try {
            if (document instanceof IDocumentExtension4) {
                doc4 = (IDocumentExtension4)document;
                rewriteSession = doc4.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
            }
            int firstLine = scanner.getFirstLineOfRegion(textBlock);
            int lastLine = scanner.getLastLineOfRegion(textBlock);
            final int column = util.getMultilineIndentColumn(firstLine, lastLine);
            IndentUtil.IndentEditAction action = new IndentUtil.IndentEditAction(column){

                public void doEdit(int line, int offset, int length, StringBuilder text) throws BadLocationException {
                    if (text != null) {
                        document.replace(offset, length, text.toString());
                    }
                    document.replace(util.getIndentedOffsetAt(line, column), 0, "## ");
                }
            };
            util.editInIndent(firstLine, lastLine, action);
        }
        catch (Throwable throwable) {
            if (doc4 != null) {
                doc4.stopRewriteSession(rewriteSession);
            }
            throw throwable;
        }
        if (doc4 != null) {
            doc4.stopRewriteSession(rewriteSession);
        }
    }
}

