/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.wikitext.r.textile.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.wikitext.core.WikitextProblemReporter;
import org.eclipse.statet.docmlet.wikitext.core.model.IWikidocModelInfo;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextSourceUnit;
import org.eclipse.statet.internal.redocs.wikitext.r.textile.Messages;
import org.eclipse.statet.jcommons.text.core.TextLineInformation;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.issues.core.BasicProblem;
import org.eclipse.statet.ltk.issues.core.Problem;
import org.eclipse.statet.ltk.issues.core.ProblemRequestor;

public class TextileValidator
extends WikitextProblemReporter {
    private static final Pattern BLOCK_START_PATTERN = Pattern.compile("\\A((?:bc|bq|pre|table|p)\\.\\.?+)(.)?");

    public void run(WikitextSourceUnit su, SourceContent content, IWikidocModelInfo model, ProblemRequestor requestor, int level, IProgressMonitor monitor) {
        Matcher matcher = BLOCK_START_PATTERN.matcher(content.getText());
        TextLineInformation lines = content.getLines();
        int numLines = lines.getNumberOfLines();
        int start = 0;
        int line = 0;
        while (line < numLines) {
            String followingCharacter;
            int end = lines.getEndOffset(line);
            matcher.region(start, end);
            if (matcher.find() && ((followingCharacter = matcher.group(2)) == null || !followingCharacter.equals(" "))) {
                String matched = matcher.group(1);
                requestor.acceptProblems((Problem)new BasicProblem("Wikidoc", 1, 0, NLS.bind((String)Messages.Validation_BlockWhitespace_message, (Object)matched), line, start, matcher.end(1)));
            }
            start = end;
            ++line;
        }
    }
}

