/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.rdata;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.statet.internal.r.rdata.BasicCombinedRElement;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.RVector;
import org.eclipse.statet.rj.data.impl.ExternalizableRObject;

public class RVectorVar<TData extends RStore>
extends BasicCombinedRElement
implements RVector<TData>,
ExternalizableRObject {
    private final TData data;
    private final long length;
    private String className1;

    public RVectorVar(TData data, long length, String className1, @Nullable BasicCombinedRElement parent, @Nullable RElementName name) {
        super(parent, name);
        if (data == null || className1 == null) {
            throw new NullPointerException();
        }
        this.data = data;
        this.length = length;
        this.className1 = className1;
    }

    public RVectorVar(RVector<TData> rObject, @Nullable BasicCombinedRElement parent, @Nullable RElementName name) {
        super(parent, name);
        this.data = rObject.getData();
        this.length = rObject.getLength();
        this.className1 = rObject.getRClassName();
    }

    public RVectorVar(RJIO io, RObjectFactory factory, @Nullable BasicCombinedRElement parent, @Nullable RElementName name) throws IOException {
        super(parent, name);
        int options = io.readInt();
        if ((options & 0x10) != 0) {
            this.className1 = io.readString();
        }
        this.length = io.readVULong((byte)(options & 7));
        assert ((options & 0x40) == 0);
        this.data = factory.readStore(io, this.length);
        if ((options & 0x10) == 0) {
            this.className1 = this.data.getBaseVectorRClassName();
        }
    }

    public void writeExternal(RJIO io, RObjectFactory factory) throws IOException {
        int options = io.getVULongGrade(this.length);
        if (!this.className1.equals(this.data.getBaseVectorRClassName())) {
            options |= 0x10;
        }
        io.writeInt(options);
        if ((options & 0x10) != 0) {
            io.writeString(this.className1);
        }
        io.writeVULong((byte)(options & 7), this.length);
        factory.writeStore(this.data, io);
    }

    public byte getRObjectType() {
        return 2;
    }

    public String getRClassName() {
        return this.className1;
    }

    public long getLength() {
        return this.length;
    }

    public @Nullable RStore getNames() {
        return null;
    }

    public TData getData() {
        return this.data;
    }

    public int getElementType() {
        return 1552;
    }

    public boolean hasModelChildren(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable IModelElement.Filter filter) {
        return false;
    }

    public List<? extends CombinedRElement> getModelChildren(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable IModelElement.Filter filter) {
        return Collections.emptyList();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RObject type=vector, class=").append(this.getRClassName());
        sb.append("\n\tlength=").append(this.getLength());
        sb.append("\n\tdata: ");
        sb.append(this.data.toString());
        return sb.toString();
    }
}

