/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.edit;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.ecommons.waltable.command.AbstractLayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.data.IDataProvider;
import org.eclipse.statet.ecommons.waltable.edit.UpdateDataCommand;
import org.eclipse.statet.ecommons.waltable.layer.DataLayer;
import org.eclipse.statet.ecommons.waltable.layer.event.CellVisualChangeEvent;
import org.eclipse.statet.internal.ecommons.waltable.WaLTablePlugin;

public class UpdateDataCommandHandler
extends AbstractLayerCommandHandler<UpdateDataCommand> {
    private final DataLayer dataLayer;

    public UpdateDataCommandHandler(DataLayer dataLayer) {
        this.dataLayer = dataLayer;
    }

    @Override
    public Class<UpdateDataCommand> getCommandClass() {
        return UpdateDataCommand.class;
    }

    @Override
    protected boolean doCommand(UpdateDataCommand command) {
        try {
            long columnPosition = command.getColumnPosition();
            long rowPosition = command.getRowPosition();
            IDataProvider dataProvider = this.dataLayer.getDataProvider();
            Object oldValue = dataProvider.getDataValue(columnPosition, rowPosition, 0, null);
            Object newValue = command.getNewValue();
            if (oldValue != null ? !oldValue.equals(newValue) : newValue != null) {
                dataProvider.setDataValue(columnPosition, rowPosition, newValue);
                this.dataLayer.fireLayerEvent(new CellVisualChangeEvent(this.dataLayer, columnPosition, rowPosition));
            }
            return true;
        }
        catch (UnsupportedOperationException e) {
            WaLTablePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.waltable.core", "Failed to update value to: " + command.getNewValue(), (Throwable)e));
            return false;
        }
    }
}

