/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceStructElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;
import org.eclipse.statet.yaml.core.ast.YamlAstNode;
import org.eclipse.statet.yaml.core.model.IYamlSourceElement;
import org.eclipse.statet.yaml.core.model.YamlElementName;

public abstract class YamlSourceElement
implements IYamlSourceElement {
    private static final ImList<YamlSourceElement> NO_CHILDREN = ImCollections.emptyList();
    protected YamlElementName name;
    protected int occurrenceCount;

    static final List<? extends IYamlSourceElement> getChildren(List<? extends IYamlSourceElement> children, IModelElement.Filter filter) {
        if (filter == null) {
            return children;
        }
        ArrayList<IYamlSourceElement> filtered = new ArrayList<IYamlSourceElement>(children.size());
        for (IYamlSourceElement iYamlSourceElement : children) {
            if (!filter.include((IModelElement)iYamlSourceElement)) continue;
            filtered.add(iYamlSourceElement);
        }
        return filtered;
    }

    static final boolean hasChildren(List<? extends IYamlSourceElement> children, IModelElement.Filter filter) {
        if (filter == null) {
            return !children.isEmpty();
        }
        for (IYamlSourceElement iYamlSourceElement : children) {
            if (!filter.include((IModelElement)iYamlSourceElement)) continue;
            return true;
        }
        return false;
    }

    protected YamlSourceElement() {
    }

    public final String getModelTypeId() {
        return "Yaml";
    }

    public String getId() {
        String name = this.getElementName().getDisplayName();
        StringBuilder sb = new StringBuilder(name.length() + 16);
        sb.append(Integer.toHexString(this.getElementType() & 0xFF0));
        sb.append(':');
        sb.append(name);
        sb.append('#');
        sb.append(this.occurrenceCount);
        return sb.toString();
    }

    public ElementName getElementName() {
        return this.name;
    }

    public TextRegion getDocumentationRange() {
        return null;
    }

    public <T> T getAdapter(Class<T> adapterType) {
        return null;
    }

    public int hashCode() {
        return (this.getElementType() & 0xFF0) * this.getElementName().hashCode() + this.occurrenceCount;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof YamlSourceElement)) {
            return false;
        }
        YamlSourceElement other = (YamlSourceElement)obj;
        return (this.getElementType() & 0xFF0) == (this.getElementType() & 0xFF0) && this.occurrenceCount == other.occurrenceCount && ((this.getElementType() & 0xF00) == 512 || this.getSourceParent().equals(other.getSourceParent())) && this.getElementName().equals(other.getElementName());
    }

    static /* synthetic */ ImList access$0() {
        return NO_CHILDREN;
    }

    public static abstract class Container
    extends YamlSourceElement {
        List<YamlSourceElement> children = YamlSourceElement.access$0();
        TextRegion nameRegion;
        private final YamlAstNode astNode;

        public Container(YamlAstNode astNode) {
            this.astNode = astNode;
        }

        public TextRegion getNameSourceRange() {
            return this.nameRegion;
        }

        public TextRegion getSourceRange() {
            return this.astNode;
        }

        @Override
        public boolean hasSourceChildren(IModelElement.Filter filter) {
            return Container.hasChildren(this.children, filter);
        }

        @Override
        public List<? extends IYamlSourceElement> getSourceChildren(IModelElement.Filter filter) {
            return Container.getChildren(this.children, filter);
        }

        @Override
        public abstract Container getModelParent();

        public boolean hasModelChildren(IModelElement.Filter filter) {
            return Container.hasChildren(this.children, filter);
        }

        public List<? extends IModelElement> getModelChildren(IModelElement.Filter filter) {
            return Container.getChildren(this.children, filter);
        }

        @Override
        public <T> T getAdapter(Class<T> adapterType) {
            if (adapterType == AstNode.class) {
                return (T)((Object)this.astNode);
            }
            return super.getAdapter(adapterType);
        }
    }

    public static class SourceContainer
    extends Container {
        private final ISourceUnit sourceUnit;

        public SourceContainer(ISourceUnit su, YamlAstNode astNode) {
            super(astNode);
            this.sourceUnit = su;
        }

        public int getElementType() {
            return 528;
        }

        @Override
        public String getId() {
            return this.sourceUnit.getId();
        }

        @Override
        public YamlElementName getElementName() {
            ElementName elementName = this.sourceUnit.getElementName();
            if (elementName instanceof YamlElementName) {
                return (YamlElementName)elementName;
            }
            return YamlElementName.create(1, elementName.getSegmentName());
        }

        public ISourceUnit getSourceUnit() {
            return this.sourceUnit;
        }

        public boolean exists() {
            ISourceUnitModelInfo modelInfo = this.getSourceUnit().getModelInfo("Yaml", 0, null);
            return modelInfo != null && modelInfo.getSourceElement() == this;
        }

        public boolean isReadOnly() {
            return this.sourceUnit.isReadOnly();
        }

        public ISourceStructElement getSourceParent() {
            return null;
        }

        @Override
        public Container getModelParent() {
            return null;
        }
    }

    public static class StructContainer
    extends Container {
        private final int type;
        private final Container parent;

        public StructContainer(int type, Container parent, YamlAstNode astNode) {
            super(astNode);
            this.type = type;
            this.parent = parent;
        }

        public final int getElementType() {
            return this.type;
        }

        public ISourceUnit getSourceUnit() {
            return this.parent.getSourceUnit();
        }

        public boolean exists() {
            return this.parent.exists();
        }

        public boolean isReadOnly() {
            return this.parent.isReadOnly();
        }

        public ISourceStructElement getSourceParent() {
            return this.parent;
        }

        @Override
        public Container getModelParent() {
            return this.parent;
        }
    }
}

