/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ltk.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.statet.internal.ltk.core.AdapterFactory;
import org.eclipse.statet.internal.ltk.core.ExtContentTypeServices;
import org.eclipse.statet.internal.ltk.core.SourceUnitManager;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.ltk.core.IExtContentTypeManager;
import org.eclipse.statet.ltk.model.core.ISourceUnitManager;
import org.osgi.framework.BundleContext;

public final class LTKCorePlugin
extends Plugin {
    public static final String BUNDLE_ID = "org.eclipse.statet.ltk.core";
    private static LTKCorePlugin instance;
    private static LTKCorePlugin gSafe;
    private boolean started;
    private final List<Disposable> disposables = new ArrayList<Disposable>();
    private ExtContentTypeServices contentTypeServices;
    private SourceUnitManager sourceUnitManager;
    private AdapterFactory modelAdapterFactory;

    public static LTKCorePlugin getInstance() {
        return instance;
    }

    public static LTKCorePlugin getSafe() {
        return gSafe;
    }

    public static void log(IStatus status) {
        LTKCorePlugin plugin = LTKCorePlugin.getInstance();
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public LTKCorePlugin() {
        instance = this;
        gSafe = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        super.start(context);
        LTKCorePlugin lTKCorePlugin = this;
        synchronized (lTKCorePlugin) {
            this.started = true;
            this.contentTypeServices = new ExtContentTypeServices();
            this.addStoppingListener(this.contentTypeServices);
            this.sourceUnitManager = new SourceUnitManager();
            this.addStoppingListener(this.sourceUnitManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            LTKCorePlugin lTKCorePlugin = this;
            synchronized (lTKCorePlugin) {
                this.started = false;
                this.contentTypeServices = null;
                this.sourceUnitManager = null;
            }
            try {
                for (Disposable listener : this.disposables) {
                    listener.dispose();
                }
            }
            finally {
                this.disposables.clear();
            }
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStoppingListener(Disposable listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        LTKCorePlugin lTKCorePlugin = this;
        synchronized (lTKCorePlugin) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.disposables.add(listener);
        }
    }

    public IExtContentTypeManager getContentTypeServices() {
        return this.contentTypeServices;
    }

    public ISourceUnitManager getSourceUnitManager() {
        return this.sourceUnitManager;
    }

    public synchronized AdapterFactory getModelAdapterFactory() {
        if (this.modelAdapterFactory == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.modelAdapterFactory = new AdapterFactory("org.eclipse.statet.ltk.ModelAdapters");
        }
        return this.modelAdapterFactory;
    }
}

