/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.issues.core.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.statet.jcommons.text.core.TextLineInformation;
import org.eclipse.statet.ltk.issues.core.ITaskTag;
import org.eclipse.statet.ltk.issues.core.TaskPriority;

public class TaskMarkerHandler {
    private final String markerId;
    private Pattern taskTagPattern;
    private Map<String, TaskPriority> taskTagMap;
    private IResource resource;

    public TaskMarkerHandler(String markerId) {
        this.markerId = markerId;
    }

    public void setup(IResource resource) {
        this.resource = resource;
    }

    public void addTaskMarker(String message, int offset, int lineNumber, String match) throws CoreException {
        TaskPriority prio = this.taskTagMap.get(match);
        IMarker marker = this.resource.createMarker(this.markerId);
        marker.setAttribute("message", (Object)message);
        marker.setAttribute("priority", prio.getMarkerPriority());
        if (lineNumber == -1) {
            lineNumber = 1;
        }
        marker.setAttribute("lineNumber", lineNumber);
        if (offset != -1) {
            marker.setAttribute("charStart", offset);
            marker.setAttribute("charEnd", offset + message.length());
        }
        marker.setAttribute("userEditable", false);
    }

    public void removeTaskMarkers() throws CoreException {
        this.resource.deleteMarkers(this.markerId, false, 2);
    }

    protected void initTaskPattern(List<ITaskTag> taskTags) {
        this.taskTagPattern = null;
        this.taskTagMap = null;
        if (taskTags.isEmpty()) {
            return;
        }
        this.taskTagMap = new HashMap<String, TaskPriority>(taskTags.size());
        String separatorRegex = "[^\\p{L}\\p{N}]";
        StringBuilder regex = new StringBuilder("[^\\p{L}\\p{N}]");
        regex.append('(');
        for (ITaskTag taskTag : taskTags) {
            regex.append(Pattern.quote(taskTag.getKeyword()));
            regex.append('|');
            this.taskTagMap.put(taskTag.getKeyword(), taskTag.getPriority());
        }
        regex.setCharAt(regex.length() - 1, ')');
        regex.append("(?:\\z|").append("[^\\p{L}\\p{N}]").append(")");
        this.taskTagPattern = Pattern.compile(regex.toString());
    }

    public void checkForTasks(String content, int offset, TextLineInformation lines) throws CoreException, BadLocationException {
        Matcher matcher;
        if (this.taskTagPattern != null && (matcher = this.taskTagPattern.matcher(content)).find()) {
            int start = matcher.start(1);
            String text = new String(content.substring(start));
            this.addTaskMarker(text, offset + start, lines.getLineOfOffset(offset) + 1, matcher.group(1));
        }
    }
}

