/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.templates;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.statet.ecommons.templates.TemplateMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public final class TemplateVariableProposal
implements ICompletionProposal {
    private final TemplateVariableResolver variable;
    private final int offset;
    private final int length;
    private final ITextViewer viewer;
    private Point selection;

    public TemplateVariableProposal(TemplateVariableResolver variable, int offset, int length, ITextViewer viewer) {
        this.variable = variable;
        this.offset = offset;
        this.length = length;
        this.viewer = viewer;
    }

    public void apply(IDocument document) {
        try {
            String variable = this.variable.getType().equals("dollar") ? "$$" : "${" + this.variable.getType() + "}";
            document.replace(this.offset, this.length, variable);
            this.selection = new Point(this.offset + variable.length(), 0);
        }
        catch (BadLocationException e) {
            Shell shell = this.viewer.getTextWidget().getShell();
            MessageDialog.openError((Shell)shell, (String)TemplateMessages.TemplateVariableProposal_error_title, (String)e.getMessage());
        }
    }

    public Point getSelection(IDocument document) {
        return this.selection;
    }

    public String getDisplayString() {
        return this.variable.getType();
    }

    public String getAdditionalProposalInfo() {
        return this.variable.getDescription();
    }

    public Image getImage() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

