/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImageRegistryUtil {
    public static final String T_VIEW = "view_16";
    public static final String T_TOOL = "tool_16";
    public static final String T_TOOLD = "tool_16_d";
    public static final String T_OBJ = "obj_16";
    public static final String T_OVR = "ovr_16";
    public static final String T_WIZBAN = "wizban";
    public static final String T_LOCTOOL = "loctool_16";
    public static final String T_LOCTOOL_D = "loctool_16_d";
    private final AbstractUIPlugin plugin;
    private final URL iconBaseURL;

    public ImageRegistryUtil(AbstractUIPlugin plugin) {
        this.plugin = plugin;
        this.iconBaseURL = plugin.getBundle().getEntry("/icons/");
    }

    public void register(String key, String prefix, String name) {
        ImageDescriptor descriptor;
        try {
            URL url = this.createIconFileURL(prefix + "/" + name);
            descriptor = this.createDescriptor(url);
        }
        catch (RuntimeException | MalformedURLException e) {
            this.plugin.getLog().log((IStatus)new Status(4, this.plugin.getBundle().getSymbolicName(), 0, String.format("Error occured while loading an image descriptor (key= %1$s).", key), (Throwable)e));
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        this.plugin.getImageRegistry().put(key, descriptor);
    }

    public void register(String key, String name) {
        ImageDescriptor descriptor;
        try {
            int typeStartIdx = key.indexOf("/images/") + 8;
            int typeEndIdx = key.indexOf(47, typeStartIdx);
            String type = key.substring(typeStartIdx, typeEndIdx);
            StringBuilder path = new StringBuilder();
            path.append(switch (type) {
                case "obj" -> "obj_16/";
                case "tool" -> "tool_16/";
                case "ovr" -> "ovr_16/";
                case "loctool" -> "loctool_16/";
                default -> throw new IllegalArgumentException(key);
            });
            if (name.charAt(0) == '.') {
                int idx;
                int endIdx = key.length();
                int doneIdx = idx = typeEndIdx + 1;
                boolean lc = false;
                while (idx < endIdx) {
                    char c = key.charAt(idx);
                    switch (c) {
                        case '$': 
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': 
                        case '_': {
                            ++idx;
                            lc = false;
                            break;
                        }
                        case '.': {
                            if (doneIdx < idx) {
                                path.append(key, doneIdx, idx);
                            }
                            path.append('-');
                            doneIdx = ++idx;
                            lc = false;
                            break;
                        }
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': 
                        case 'G': 
                        case 'H': 
                        case 'I': 
                        case 'J': 
                        case 'K': 
                        case 'L': 
                        case 'M': 
                        case 'N': 
                        case 'O': 
                        case 'P': 
                        case 'Q': 
                        case 'R': 
                        case 'S': 
                        case 'T': 
                        case 'U': 
                        case 'V': 
                        case 'W': 
                        case 'X': 
                        case 'Y': 
                        case 'Z': {
                            if (doneIdx < idx) {
                                path.append(key, doneIdx, idx);
                            }
                            if (lc) {
                                path.append('_');
                            }
                            path.append((char)(c + 32));
                            doneIdx = ++idx;
                            lc = false;
                            break;
                        }
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': 
                        case 'g': 
                        case 'h': 
                        case 'i': 
                        case 'j': 
                        case 'k': 
                        case 'l': 
                        case 'm': 
                        case 'n': 
                        case 'o': 
                        case 'p': 
                        case 'q': 
                        case 'r': 
                        case 's': 
                        case 't': 
                        case 'u': 
                        case 'v': 
                        case 'w': 
                        case 'x': 
                        case 'y': 
                        case 'z': {
                            ++idx;
                            lc = true;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(key);
                        }
                    }
                }
                if (doneIdx < endIdx) {
                    path.append(key, doneIdx, endIdx);
                }
            }
            path.append(name);
            URL url = this.createIconFileURL(path.toString());
            descriptor = this.createDescriptor(url);
        }
        catch (RuntimeException | MalformedURLException e) {
            this.plugin.getLog().log((IStatus)new Status(4, this.plugin.getBundle().getSymbolicName(), 0, String.format("Error occured while loading an image descriptor (key= %1$s).", key), (Throwable)e));
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        this.plugin.getImageRegistry().put(key, descriptor);
    }

    public void register(String key) {
        this.register(key, ".png");
    }

    protected URL createIconFileURL(String path) throws MalformedURLException {
        if (this.iconBaseURL == null) {
            throw new MalformedURLException();
        }
        URL url = new URL(this.iconBaseURL, path);
        return url;
    }

    protected ImageDescriptor createDescriptor(URL url) {
        return ImageDescriptor.createFromURL((URL)url);
    }
}

