/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.resize.core;

import org.eclipse.statet.ecommons.waltable.core.command.AbstractLayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.data.core.DataLayer;
import org.eclipse.statet.ecommons.waltable.resize.core.MultiRowResizeCommand;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class MultiRowResizeCommandHandler
extends AbstractLayerCommandHandler<MultiRowResizeCommand> {
    private final DataLayer dataLayer;

    public MultiRowResizeCommandHandler(DataLayer dataLayer) {
        this.dataLayer = dataLayer;
    }

    @Override
    public Class<MultiRowResizeCommand> getCommandClass() {
        return MultiRowResizeCommand.class;
    }

    @Override
    protected boolean doCommand(MultiRowResizeCommand command) {
        LRangeList.ValueIterator rowIter = new LRangeList.ValueIterator(command.getPositions());
        while (rowIter.hasNext()) {
            long rowPosition = rowIter.nextLong();
            this.dataLayer.setRowHeightByPosition(rowPosition, command.getRowHeight(rowPosition));
        }
        return true;
    }
}

