/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.console.ui.snippets;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.ui.ConfigurationBlock;
import org.eclipse.statet.ecommons.templates.TemplateVariableProcessor;
import org.eclipse.statet.ecommons.ui.components.CustomizableVariableSelectionDialog;
import org.eclipse.statet.ecommons.ui.util.VariableFilterUtils;
import org.eclipse.statet.internal.r.console.ui.RConsoleUIPlugin;
import org.eclipse.statet.internal.r.console.ui.snippets.Messages;
import org.eclipse.statet.internal.r.console.ui.snippets.RSnippets;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.ltk.ui.templates.config.CodeTemplateConfigurationBlock;
import org.eclipse.statet.ltk.ui.templates.config.EditTemplateDialog;
import org.eclipse.statet.ltk.ui.templates.config.ITemplateCategoryConfiguration;
import org.eclipse.statet.ltk.ui.templates.config.ITemplateContribution;
import org.eclipse.statet.ltk.ui.templates.config.TemplateCategory;
import org.eclipse.statet.ltk.ui.templates.config.TemplateStoreContribution;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.ui.RUI;
import org.eclipse.statet.r.ui.sourceediting.RTemplateSourceViewerConfigurator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.templates.ContextTypeRegistry;
import org.eclipse.text.templates.TemplatePersistenceData;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

class SnippetConfigurationBlock
extends CodeTemplateConfigurationBlock {
    private static final String R_SNIPPET_CATEGORY_ID = "r.ConsoleSnippet";
    private final ICommandService commandService;
    private final RSnippets snippets = RConsoleUIPlugin.getInstance().getRSnippets();

    public SnippetConfigurationBlock() throws CoreException {
        super(Messages.SnippetTemplates_title, 1, null);
        this.setCategories((List)ImCollections.newList((Object)new TemplateCategory(R_SNIPPET_CATEGORY_ID, RConsoleUIPlugin.getInstance().getImageRegistry().getDescriptor("org.eclipse.statet.r.console.ui/images/obj/snippets"), Messages.SnippetTemplates_RSnippet_label, RUI.getImageDescriptor((String)"org.eclipse.statet.r/images/obj/r_script"), (ITemplateCategoryConfiguration)new RSnippetTemplateConfiguration(this.snippets))));
        this.commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
    }

    protected String getListLabel() {
        return "Code Snippe&ts";
    }

    protected void createBlockArea(Composite pageComposite) {
        super.createBlockArea(pageComposite);
        Link keyLink = this.addLinkControl(pageComposite, Messages.SnippetTemplates_KeysNote_label, new ConfigurationBlock.LinkSelectionListener((ConfigurationBlock)this){
            private ParameterizedCommand command;

            protected Object getData(SelectionEvent e) {
                if (this.command == null) {
                    Command command = SnippetConfigurationBlock.this.commandService.getCommand("org.eclipse.statet.r.commands.SubmitRSnippet");
                    List templates = SnippetConfigurationBlock.this.getTemplates((TemplateCategory)SnippetConfigurationBlock.this.getCategories().get(0));
                    if (!templates.isEmpty()) {
                        String name = ((CodeTemplateConfigurationBlock.TemplateItem)templates.get(0)).getData().getTemplate().getName();
                        Map<String, String> parameters = Collections.singletonMap("snippet", name);
                        this.command = ParameterizedCommand.generateCommand((Command)command, parameters);
                    }
                }
                return this.command;
            }
        });
        keyLink.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    protected EditTemplateDialog createEditDialog(Template template, int command, SourceEditorViewerConfigurator configurator, TemplateVariableProcessor processor, ContextTypeRegistry registry) {
        return new RSnippetEditDialog(this.getShell(), template, (command & 3) != 0, 2, configurator, processor, registry, this.snippets);
    }

    private static class RSnippetEditDialog
    extends EditTemplateDialog {
        private final RSnippets snippets;

        private RSnippetEditDialog(Shell parent, Template template, boolean edit, int flags, SourceEditorViewerConfigurator configurator, TemplateVariableProcessor processor, ContextTypeRegistry registry, RSnippets snippets) {
            super(parent, template, edit, flags, configurator, processor, registry, "org.eclipse.statet.r.ui/launchingconfig");
            this.snippets = snippets;
        }

        protected IStatus validate(TemplateContextType contextType, String text) {
            return this.snippets.validate(contextType, text);
        }

        protected void insertVariablePressed() {
            CustomizableVariableSelectionDialog dialog = new CustomizableVariableSelectionDialog(this.getShell());
            ImList filters = VariableFilterUtils.DEFAULT_INTERACTIVE_FILTERS;
            for (StringVariableSelectionDialog.VariableFilter filter : filters) {
                dialog.addVariableFilter(filter);
            }
            dialog.addAdditional(RSnippets.ECHO_ENABLED_VARIABLE);
            dialog.addAdditional(RSnippets.RESOURCE_ENCODING_VARIABLE);
            if (dialog.open() != 0) {
                return;
            }
            String variable = dialog.getVariableExpression();
            if (variable == null) {
                return;
            }
            this.insertText(variable);
        }
    }

    private static class RSnippetTemplateConfiguration
    implements ITemplateCategoryConfiguration {
        private final RSnippets snippets;

        public RSnippetTemplateConfiguration(RSnippets snippets) {
            this.snippets = snippets;
        }

        public ITemplateContribution getTemplates() {
            return new TemplateStoreContribution(this.snippets.getTemplateStore());
        }

        public Preference<String> getDefaultPref() {
            return null;
        }

        public ContextTypeRegistry getContextTypeRegistry() {
            return this.snippets.getTemplateContextRegistry();
        }

        public String getDefaultContextTypeId() {
            return "org.eclipse.statet.r.templates.RConsoleSnippetContextType";
        }

        public String getViewerConfigId(TemplatePersistenceData data) {
            return "org.eclipse.statet.r.templates.RConsoleSnippetContextType";
        }

        public SourceEditorViewerConfigurator createViewerConfiguator(String viewerConfigId, TemplatePersistenceData data, TemplateVariableProcessor templateProcessor, IProject project) {
            return new RTemplateSourceViewerConfigurator(RCore.getWorkbenchAccess(), templateProcessor);
        }
    }
}

