/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.wizards.Messages;
import org.eclipse.statet.internal.r.ui.wizards.NewRProjectWizardPage;
import org.eclipse.statet.ltk.ui.wizards.LTKWizardsMessages;
import org.eclipse.statet.ltk.ui.wizards.NewElementWizard;
import org.eclipse.statet.r.core.project.RProjects;
import org.eclipse.statet.r.ui.RUI;
import org.eclipse.ui.dialogs.WizardNewProjectReferencePage;

public class NewRProjectWizard
extends NewElementWizard {
    private NewRProjectWizardPage firstPage;
    private WizardNewProjectReferencePage referencePage;
    private NewElementWizard.NewProject newRProject;

    public NewRProjectWizard() {
        this.setDialogSettings(DialogUtils.getDialogSettings((Plugin)RUIPlugin.getInstance(), (String)"NewElementWizard"));
        this.setDefaultPageImageDescriptor(RUI.getImageDescriptor("org.eclipse.statet.r.ui/images/wizban/new.r_project"));
        this.setWindowTitle(Messages.NewRProjectWizard_title);
    }

    public void addPages() {
        super.addPages();
        this.firstPage = new NewRProjectWizardPage(this.getSelection(), null);
        this.addPage((IWizardPage)this.firstPage);
        if (ResourcesPlugin.getWorkspace().getRoot().getProjects().length > 0) {
            this.referencePage = new WizardNewProjectReferencePage("BasicProjectReferencePage");
            this.referencePage.setTitle(LTKWizardsMessages.NewProjectReferencePage_title);
            this.referencePage.setDescription(LTKWizardsMessages.NewProjectReferencePage_description);
            this.addPage((IWizardPage)this.referencePage);
        }
    }

    public boolean performFinish() {
        this.newRProject = new NewElementWizard.NewProject(this, this.firstPage.getProjectHandle(), this.firstPage.useDefaults() ? null : this.firstPage.getLocationPath(), this.referencePage != null ? this.referencePage.getReferencedProjects() : null, this.firstPage.getSelectedWorkingSets()){

            protected void doConfigProject(IProject project, IProgressMonitor monitor) throws CoreException {
                RProjects.setupRProject((IProject)NewRProjectWizard.this.newRProject.getResource(), (IProgressMonitor)monitor);
            }
        };
        boolean result = super.performFinish();
        if (result && this.newRProject.getResource() != null) {
            this.updatePerspective();
            this.selectAndReveal((IResource)this.newRProject.getResource());
        }
        return result;
    }

    protected void performOperations(IProgressMonitor monitor) throws InterruptedException, CoreException, InvocationTargetException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)"Create new R project...", (int)10);
        this.newRProject.createProject((IProgressMonitor)m.newChild(10));
    }
}

