/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import org.eclipse.statet.internal.jcommons.collections.AbstractImList;
import org.eclipse.statet.internal.jcommons.collections.ArrayUtils;
import org.eclipse.statet.internal.jcommons.collections.ImArrayIdentityList;
import org.eclipse.statet.internal.jcommons.collections.ImArrayList;
import org.eclipse.statet.internal.jcommons.collections.ImArraySubList;
import org.eclipse.statet.internal.jcommons.collections.ImEmptyIdentityList;
import org.eclipse.statet.internal.jcommons.collections.ImSingletonIdentityList;
import org.eclipse.statet.jcommons.collections.AbstractImCollection;
import org.eclipse.statet.jcommons.collections.IdentityList;
import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public final class ImArrayIdentitySubList<E>
extends AbstractImList<E>
implements ImIdentityList<E>,
RandomAccess {
    private final E[] array;
    private final int offset;
    private final int size;

    public ImArrayIdentitySubList(E[] array, int fromIndex, int toIndex) {
        this.array = array;
        this.offset = fromIndex;
        this.size = toIndex - fromIndex;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(@Nullable Object e) {
        return this.indexOf(e) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> iter = c.iterator();
        while (iter.hasNext()) {
            if (this.indexOf(iter.next()) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        return this.array[this.offset + index];
    }

    @Override
    public E getFirst() {
        return this.array[this.offset];
    }

    @Override
    public E getLast() {
        return this.array[this.offset + this.size - 1];
    }

    @Override
    public int indexOf(@Nullable Object e) {
        int toIndex = this.offset + this.size;
        int i = this.offset;
        while (i < toIndex) {
            if (e == this.array[i]) {
                return i - this.offset;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(@Nullable Object e) {
        int i = this.offset + this.size - 1;
        while (i >= this.offset) {
            if (e == this.array[i]) {
                return i - this.offset;
            }
            --i;
        }
        return -1;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iter(0);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new Iter(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        return new Iter(index);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.array, this.offset, this.offset + this.size, 1040);
    }

    @Override
    public ImIdentityList<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size) {
            throw new IndexOutOfBoundsException("fromIndex= " + fromIndex + ", toIndex= " + toIndex + ", size= " + this.size);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex > toIndex: fromIndex= " + fromIndex + ", toIndex= " + toIndex);
        }
        int l = toIndex - fromIndex;
        if (l == this.size) {
            return this;
        }
        if (l == 0) {
            return ImEmptyIdentityList.INSTANCE;
        }
        if (l == 1) {
            return new ImSingletonIdentityList<E>(this.array[this.offset + fromIndex]);
        }
        return new ImArrayIdentitySubList<E>(this.array, this.offset + fromIndex, this.offset + toIndex);
    }

    @Override
    public Object[] toArray() {
        Object[] dest = new Object[this.size];
        System.arraycopy(this.array, this.offset, dest, 0, this.size);
        return dest;
    }

    @Override
    public <T> T[] toArray(T[] dest) {
        if (dest.length < this.size) {
            return Arrays.copyOfRange(this.array, this.offset, this.offset + this.size, dest.getClass());
        }
        System.arraycopy(this.array, this.offset, dest, 0, this.size);
        if (dest.length > this.size) {
            dest[this.size] = null;
        }
        return dest;
    }

    @Override
    public <T> T[] toArray(IntFunction<T[]> generator) {
        T[] dest = generator.apply(this.size);
        System.arraycopy(this.array, this.offset, dest, 0, this.size);
        return dest;
    }

    @Override
    public void copyTo(int srcIndex, Object[] dest, int destIndex, int length) {
        System.arraycopy(this.array, this.offset + srcIndex, dest, destIndex, length);
    }

    @Override
    public void copyTo(Object[] dest, int destIndex) {
        System.arraycopy(this.array, this.offset, dest, destIndex, this.size);
    }

    @Override
    public ImList<E> toList() {
        return new ImArraySubList<E>(this.array, this.offset, this.offset + this.size);
    }

    @Override
    public ImIdentityList<E> toIdentityList() {
        return this;
    }

    @Override
    public ImIdentityList<E> reversed() {
        return new ImArrayIdentityList<E>(ArrayUtils.copyReverse(this.array, this.offset, this.offset + this.size));
    }

    @Override
    public <R> ImCollection.MappingResult<R> map(Function<E, R> mapper) {
        Object[] result = new Object[this.size];
        int i = 0;
        while (i < this.size) {
            result[i] = mapper.apply(this.array[this.offset + i]);
            ++i;
        }
        return new ImArrayList<Object>(result);
    }

    @Override
    public @Nullable E findFirst(Predicate<E> predicate) {
        int i = 0;
        while (i < this.size) {
            E e = this.array[this.offset + i];
            if (predicate.test(e)) {
                return e;
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean anyMatch(Predicate<? super E> predicate) {
        int i = 0;
        while (i < this.size) {
            if (predicate.test(this.array[this.offset + i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean allMatch(Predicate<? super E> predicate) {
        int i = 0;
        while (i < this.size) {
            if (!predicate.test(this.array[this.offset + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean noneMatch(Predicate<? super E> predicate) {
        int i = 0;
        while (i < this.size) {
            if (predicate.test(this.array[this.offset + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        int toIndex = this.offset + this.size;
        int i = this.offset;
        while (i < toIndex) {
            hashCode = 31 * hashCode + (this.array[i] != null ? this.array[i].hashCode() : 0);
            ++i;
        }
        return hashCode;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IdentityList) {
            IdentityList other = (IdentityList)obj;
            if (this.size != other.size()) {
                return false;
            }
            ListIterator otherIter = other.listIterator();
            int toIndex = this.offset + this.size;
            int i = this.offset;
            while (i < toIndex) {
                if (this.array[i] != otherIter.next()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (obj instanceof List) {
            List other = (List)obj;
            if (this.size != other.size()) {
                return false;
            }
            ListIterator otherIter = other.listIterator();
            int toIndex = this.offset + this.size;
            int i = this.offset;
            while (i < toIndex) {
                if (!Objects.equals(this.array[i], otherIter.next())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    private class Iter
    extends AbstractImCollection.AbstractImListIter<E> {
        private int cursor;

        Iter(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < ImArrayIdentitySubList.this.size;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public E next() {
            if (this.cursor >= ImArrayIdentitySubList.this.size) {
                throw new NoSuchElementException();
            }
            return ImArrayIdentitySubList.this.array[ImArrayIdentitySubList.this.offset + this.cursor++];
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public E previous() {
            if (this.cursor <= 0) {
                throw new NoSuchElementException();
            }
            return ImArrayIdentitySubList.this.array[ImArrayIdentitySubList.this.offset + --this.cursor];
        }
    }
}

