/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.io;

import java.net.URISyntaxException;
import org.eclipse.statet.internal.jcommons.io.AbstractNestedArchiveStringUrl;
import org.eclipse.statet.internal.jcommons.io.CommonsUriInternals;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public final class NestedJarStringUrl
extends AbstractNestedArchiveStringUrl {
    private final int nestSepIndex;
    private final int jarSepIndex;
    private final int fragSepIndex;

    public NestedJarStringUrl(String urlString, int jarSepIndex) throws URISyntaxException {
        super(urlString);
        int nestSepIdx = urlString.indexOf("/!", 11);
        if (nestSepIdx == -1 || nestSepIdx >= jarSepIndex - 1) {
            throw new URISyntaxException(urlString, "Nested JAR separator '/!' is missing");
        }
        int fragmentIdx = urlString.indexOf(35, nestSepIdx);
        this.nestSepIndex = nestSepIdx;
        this.jarSepIndex = jarSepIndex;
        this.fragSepIndex = fragmentIdx != -1 ? fragmentIdx : urlString.length();
    }

    public NestedJarStringUrl(String urlString) throws URISyntaxException {
        super(urlString);
        if (!CommonsUriInternals.isSchemeUrl(urlString, "jar:nested")) {
            throw new IllegalArgumentException("url= " + urlString);
        }
        int jarSepIdx = urlString.indexOf("!/", 11);
        if (jarSepIdx == -1) {
            throw new URISyntaxException(urlString, "JAR content separator '!/' is missing");
        }
        int nestSepIdx = urlString.indexOf("/!", 11);
        if (nestSepIdx == -1 || nestSepIdx >= jarSepIdx - 1) {
            throw new URISyntaxException(urlString, "Nested JAR separator '/!' is missing");
        }
        int fragmentIdx = urlString.indexOf(35, jarSepIdx);
        this.nestSepIndex = nestSepIdx;
        this.jarSepIndex = jarSepIdx;
        this.fragSepIndex = fragmentIdx != -1 ? fragmentIdx : urlString.length();
    }

    @Override
    public String getOuterArchiveType() {
        return "jar";
    }

    @Override
    protected String createOuterArchiveUrl(String urlString) {
        StringBuilder sb = new StringBuilder(this.nestSepIndex - 6);
        sb.append("file:");
        sb.append(urlString, 11, this.nestSepIndex);
        return sb.toString();
    }

    @Override
    public String getInnerArchiveType() {
        return "jar";
    }

    @Override
    protected String createInnerArchiveUrl(String urlString) throws URISyntaxException {
        StringBuilder sb = new StringBuilder(this.jarSepIndex - 2);
        sb.append("jar:file:");
        sb.append(urlString, 11, this.jarSepIndex);
        sb.replace(this.nestSepIndex - 2, this.nestSepIndex, "!/");
        return sb.toString();
    }

    @Override
    protected String createEntryPath(String urlString) {
        return urlString.substring(this.jarSepIndex + 2, this.fragSepIndex);
    }
}

