/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.apps.ui;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.r.apps.ui.RApp;

@NonNullByDefault
public class AppRegistry {
    public static final byte APP_STARTED = 1;
    public static final byte APP_STOPPED = 2;
    private static final AppRegistry INSTANCE = new AppRegistry();
    private final Map<URI, AppEntry> sessions = new HashMap<URI, AppEntry>();
    private final CopyOnWriteIdentityListSet<Listener> listeners = new CopyOnWriteIdentityListSet();

    public static AppRegistry getInstance() {
        return INSTANCE;
    }

    public void addListener(Listener listener) {
        this.listeners.add((Object)((Listener)ObjectUtils.nonNullAssert((Object)listener)));
    }

    public void removeListener(Listener listener) {
        this.listeners.remove((Object)listener);
    }

    private void notifyListeners(AppStateEvent event) {
        for (Listener listener : this.listeners) {
            listener.onAppStateChanged(event);
        }
    }

    public synchronized void onAppStarted(URI id, RApp app) {
        AppEntry entry = this.sessions.computeIfAbsent(id, AppEntry::new);
        if (entry.isRunning) {
            this.notifyListeners(new AppStateEvent(2, id, entry.app));
        }
        entry.app = app;
        entry.isRunning = true;
        this.notifyListeners(new AppStateEvent(1, id, app));
    }

    public synchronized void onAppStopped(URI id, RApp app) {
        AppEntry entry = this.sessions.get(id);
        if (entry != null && entry.app == app) {
            entry.isRunning = false;
            this.notifyListeners(new AppStateEvent(2, id, app));
        }
    }

    public synchronized @Nullable RApp getApp(URI id) {
        AppEntry entry = this.sessions.get(id);
        return entry != null ? entry.app : null;
    }

    public synchronized @Nullable RApp getApp(Tool tool) {
        for (AppEntry entry : this.sessions.values()) {
            if (!entry.isRunning || entry.app.getTool() != tool) continue;
            return entry.app;
        }
        return null;
    }

    private static class AppEntry {
        private final URI id;
        private RApp app;
        private boolean isRunning;

        public AppEntry(URI id) {
            this.id = id;
        }
    }

    public static class AppStateEvent
    extends RApp.AppEvent {
        private final byte type;
        private final URI id;

        public AppStateEvent(byte type, URI id, RApp app) {
            super(app);
            this.type = type;
            this.id = id;
        }

        public byte getType() {
            return this.type;
        }

        public URI getId() {
            return this.id;
        }
    }

    public static interface Listener {
        public void onAppStateChanged(AppStateEvent var1);
    }
}

