/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IErrorReportingExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugModelPresentationExtension;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.debug.core.model.IndexedVariableItem;
import org.eclipse.statet.ecommons.debug.core.model.IndexedVariablePartition;
import org.eclipse.statet.ecommons.debug.core.model.VariableDim;
import org.eclipse.statet.ecommons.debug.ui.ECommonsDebugUIImageDescriptor;
import org.eclipse.statet.ecommons.debug.ui.ECommonsDebugUIResources;
import org.eclipse.statet.ecommons.ui.jface.resource.ImageDescriptorRegistry;
import org.eclipse.statet.internal.r.debug.ui.Messages;
import org.eclipse.statet.internal.r.debug.ui.RDebugUIPlugin;
import org.eclipse.statet.internal.r.debug.ui.RRuntimeSourceEditorInput;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.debug.core.RDebugTarget;
import org.eclipse.statet.r.debug.core.RElementVariable;
import org.eclipse.statet.r.debug.core.RStackFrame;
import org.eclipse.statet.r.debug.core.RThread;
import org.eclipse.statet.r.debug.core.RValue;
import org.eclipse.statet.r.debug.core.RVariable;
import org.eclipse.statet.r.debug.core.breakpoints.RBreakpoint;
import org.eclipse.statet.r.debug.core.breakpoints.RBreakpointStatus;
import org.eclipse.statet.r.debug.core.breakpoints.RExceptionBreakpointStatus;
import org.eclipse.statet.r.debug.core.breakpoints.RLineBreakpoint;
import org.eclipse.statet.r.debug.core.breakpoints.RMethodBreakpoint;
import org.eclipse.statet.r.debug.core.breakpoints.RMethodBreakpointStatus;
import org.eclipse.statet.r.debug.core.sourcelookup.RRuntimeSourceFragment;
import org.eclipse.statet.r.debug.core.sourcelookup.RSourceLookupMatch;
import org.eclipse.statet.r.ui.RLabelProvider;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RReference;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class RDebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation,
IDebugModelPresentationExtension {
    private static final boolean CHECK_TEXT_LENGTH = "gtk".equals(Platform.getWS());
    private static boolean isResourcesInitilized = false;
    private boolean isInitilized;
    private ImageRegistry imageRegistry;
    private ImageDescriptorRegistry imageDescriptorRegistry;
    private final RLabelProvider rLabelProvider = new RLabelProvider();
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    public void dispose() {
        super.dispose();
        this.rLabelProvider.dispose();
        this.attributes.clear();
    }

    public void setAttribute(String attribute, Object value) {
        if (attribute == null) {
            return;
        }
        this.attributes.put(attribute, value);
    }

    protected final boolean isShowVariableTypeNames() {
        Boolean value = (Boolean)this.attributes.get("org.eclipse.debug.ui.displayVariableTypeNames");
        return value != null ? value : false;
    }

    public boolean requiresUIThread(Object element) {
        return !isResourcesInitilized;
    }

    private void init() {
        RDebugUIPlugin plugin = RDebugUIPlugin.getInstance();
        this.imageRegistry = plugin.getImageRegistry();
        this.imageDescriptorRegistry = plugin.getImageDescriptorRegistry();
        this.isInitilized = true;
        isResourcesInitilized = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Image getImage(Object element) {
        if (!this.isInitilized) {
            this.init();
        }
        try {
            if (element instanceof RBreakpoint) {
                return this.getImage((RBreakpoint)element);
            }
            if (element instanceof IErrorReportingExpression) {
                if (!(element instanceof IWatchExpression)) return this.imageRegistry.get("org.eclipse.statet.r.images/obj/r_inspect_expression");
                return null;
            }
            if (element instanceof RThread) {
                return this.getImage((RThread)element);
            }
            if (!(element instanceof IVariable)) return null;
            if (element instanceof RElementVariable) {
                CombinedRElement rElement = ((RElementVariable)element).getElement();
                if (rElement.getRObjectType() != 14) return this.rLabelProvider.getImage((LtkModelElement)rElement);
                RObject resolved = ((RReference)rElement).getResolvedRObject();
                if (!(resolved instanceof CombinedRElement)) return this.rLabelProvider.getImage((LtkModelElement)rElement);
                rElement = (CombinedRElement)resolved;
                return this.rLabelProvider.getImage((LtkModelElement)rElement);
            }
            if (element instanceof IndexedVariablePartition) {
                return ECommonsDebugUIResources.INSTANCE.getImage("org.eclipse.statet.ecommons.debug/images/obj/VariablePartition");
            }
            if (element instanceof IndexedVariableItem) {
                return ECommonsDebugUIResources.INSTANCE.getImage("org.eclipse.statet.ecommons.debug/images/obj/VariableItem");
            }
            if (!(element instanceof VariableDim)) return null;
            return ECommonsDebugUIResources.INSTANCE.getImage("org.eclipse.statet.ecommons.debug/images/obj/VariableDim");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public String getText(Object element) {
        String text = null;
        try {
            if (element instanceof RDebugTarget) {
                text = this.getText((RDebugTarget)element);
            } else if (element instanceof RBreakpoint) {
                text = this.getText((RBreakpoint)element);
            } else if (element instanceof RThread) {
                text = this.getText((RThread)element);
            } else if (element instanceof RStackFrame) {
                text = this.getText((RStackFrame)element);
            } else if (element instanceof RVariable) {
                text = this.getText((RVariable)element);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (CHECK_TEXT_LENGTH && text != null && text.length() > 2000) {
            return text.substring(0, 2000);
        }
        return text;
    }

    protected String getText(RDebugTarget target) throws CoreException {
        StringBuilder sb = new StringBuilder();
        if (target.isTerminated()) {
            sb.append("<terminated> ");
        } else if (target.isDisconnected()) {
            sb.append("<disconntected> ");
        }
        sb.append(target.getName());
        if (target.isSuspended()) {
            sb.append(" (Suspended)");
        }
        return sb.toString();
    }

    protected Image getImage(RThread thread) throws CoreException {
        if (thread.isSuspended() || thread.getDebugTarget().isSuspended()) {
            return DebugUITools.getImage((String)"IMG_OBJS_THREAD_SUSPENDED");
        }
        return DebugUITools.getImage((String)"IMG_OBJS_THREAD_RUNNING");
    }

    protected String getText(RThread thread) throws CoreException {
        StringBuilder sb = new StringBuilder(thread.getName());
        if (thread.isSuspended()) {
            RBreakpointStatus status = this.getBreakpointStatus(thread);
            if (status != null) {
                String label;
                boolean a = false;
                if (status instanceof RMethodBreakpointStatus) {
                    RMethodBreakpointStatus mbStatus = (RMethodBreakpointStatus)status;
                    if (mbStatus.isEntry()) {
                        sb.append(" (Suspended at entry of ");
                        a = true;
                    } else if (mbStatus.isExit()) {
                        sb.append(" (Suspended at exit of ");
                        a = true;
                    }
                }
                if (status instanceof RExceptionBreakpointStatus) {
                    sb.append(" (Suspended on ");
                    a = true;
                }
                if (!a) {
                    sb.append(" (Suspended in ");
                    a = true;
                }
                sb.append((label = status.getLabel()) != null ? label : "?");
                sb.append(" - hit breakpoint");
                sb.append(")");
            } else {
                sb.append(" (Suspended)");
            }
        } else if (thread.isStepping()) {
            sb.append(" (Stepping)");
        } else {
            sb.append(" (Running)");
        }
        return sb.toString();
    }

    private RBreakpointStatus getBreakpointStatus(RThread thread) {
        RStackFrame frame = thread.getTopStackFrame();
        if (frame != null) {
            return (RBreakpointStatus)frame.getAdapter(RBreakpointStatus.class);
        }
        return null;
    }

    protected String getText(RStackFrame frame) throws CoreException {
        StringBuilder sb = new StringBuilder(32);
        if (frame.getPosition() >= 0) {
            sb.append(frame.getPosition());
            sb.append(": ");
        }
        sb.append(frame.getName());
        String fileName = frame.getInfoFileName();
        if (fileName != null) {
            sb.append("  \u00b7  ");
            sb.append(fileName);
            int number = frame.getInfoLineNumber();
            if (number >= 0) {
                sb.append("#");
                sb.append(number);
            }
        }
        return sb.toString();
    }

    protected Image getImage(RBreakpoint breakpoint) throws CoreException {
        int flags = this.computeBreakpointAdornmentFlags(breakpoint);
        String imageKey = breakpoint.getBreakpointType() == "org.eclipse.statet.r.debugBreakpoints.RExceptionBreakpoint" ? ((flags & 1) != 0 ? "org.eclipse.statet.r.images/obj/r_exception" : "org.eclipse.statet.r.images/obj/r_exception.disabled") : ((flags & 0x10) != 0 ? ((flags & 1) != 0 ? "org.eclipse.statet.r.images/obj/r_toplevel_breakpoint" : "org.eclipse.statet.r.images/obj/r_toplevel_breakpoint.disabled") : ((flags & 1) != 0 ? "org.eclipse.statet.r.images/obj/r_breakpoint" : "org.eclipse.statet.r.images/obj/r_breakpoint.disabled"));
        ECommonsDebugUIImageDescriptor descriptor = new ECommonsDebugUIImageDescriptor(RDebugUIPlugin.getInstance().getImageRegistry().getDescriptor(imageKey), flags);
        return this.imageDescriptorRegistry.get((ImageDescriptor)descriptor);
    }

    protected String getText(RBreakpoint breakpoint) throws CoreException {
        StringBuilder text = new StringBuilder();
        if (breakpoint.getBreakpointType() == "org.eclipse.statet.r.debugBreakpoints.RExceptionBreakpoint") {
            return "R errors/stops";
        }
        if (breakpoint instanceof RLineBreakpoint) {
            RLineBreakpoint lineBreakpoint = (RLineBreakpoint)breakpoint;
            IResource resource = breakpoint.getMarker().getResource();
            if (resource != null) {
                text.append(resource.getName());
            }
            try {
                int lineNumber = lineBreakpoint.getLineNumber();
                text.append(" [");
                text.append(NLS.bind((String)Messages.Breakpoint_Line_label, (Object)Integer.toString(lineNumber)));
                text.append(']');
            }
            catch (CoreException lineNumber) {
                // empty catch block
            }
            text.append(" - ");
            String subLabel = lineBreakpoint.getSubLabel();
            if (subLabel != null) {
                text.append(subLabel);
                text.append(' ');
                text.append(Messages.Breakpoint_SubLabel_copula);
                text.append(' ');
            }
            switch (lineBreakpoint.getElementType()) {
                case 1: {
                    text.append(Messages.Breakpoint_Function_prefix);
                    text.append(' ');
                    break;
                }
                case 2: {
                    text.append(Messages.Breakpoint_S4Method_prefix);
                    text.append(' ');
                    break;
                }
                case 9: {
                    text.append(Messages.Breakpoint_ScriptLine_prefix);
                    text.append(' ');
                }
            }
            String elementLabel = lineBreakpoint.getElementLabel();
            if (elementLabel != null) {
                text.append(elementLabel);
            } else {
                text.append("?");
            }
        } else {
            return null;
        }
        return text.toString();
    }

    private int computeBreakpointAdornmentFlags(RBreakpoint breakpoint) {
        int flags = 0;
        try {
            if (breakpoint.isEnabled()) {
                flags |= 1;
            }
            if (breakpoint.isInstalled()) {
                flags |= 2;
            }
            if (breakpoint.getBreakpointType() == "org.eclipse.statet.r.debugBreakpoints.RLineBreakpoint") {
                RLineBreakpoint lineBreakpoint = (RLineBreakpoint)breakpoint;
                if (lineBreakpoint.getElementType() == 9) {
                    flags |= 0x10;
                } else if (lineBreakpoint.isConditionEnabled()) {
                    flags |= 0x100;
                }
            } else if (breakpoint.getBreakpointType() == "org.eclipse.statet.r.debugBreakpoints.RMethodBreakpoint") {
                RMethodBreakpoint methodBreakpoint = (RMethodBreakpoint)breakpoint;
                if (methodBreakpoint.isConditionEnabled()) {
                    flags |= 0x100;
                }
                if (methodBreakpoint.isEntry()) {
                    flags |= 0x1000;
                }
                if (methodBreakpoint.isExit()) {
                    flags |= 0x2000;
                }
            } else {
                breakpoint.getBreakpointType();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return flags;
    }

    protected String getText(RVariable variable) {
        StringBuilder text = new StringBuilder();
        if (this.isShowVariableTypeNames()) {
            try {
                text.append(variable.getReferenceTypeName());
            }
            catch (DebugException e) {
                text.append("<unknown type>");
            }
            text.append(' ');
        }
        text.append(variable.getName());
        String valueString = null;
        try {
            valueString = variable.getValue().getValueString();
        }
        catch (DebugException e) {
            valueString = "<unknown>";
        }
        if (!valueString.isEmpty()) {
            text.append("= ");
            text.append(valueString);
        }
        return text.toString();
    }

    public IEditorInput getEditorInput(Object element) {
        if (element instanceof IMarker) {
            element = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint((IMarker)element);
        }
        if (element instanceof RBreakpoint) {
            element = ((RBreakpoint)element).getMarker().getResource();
        }
        if (element instanceof RSourceLookupMatch) {
            element = ((RSourceLookupMatch)element).getElement();
        }
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof IFileStore) {
            return new FileStoreEditorInput((IFileStore)element);
        }
        if (element instanceof RRuntimeSourceFragment) {
            return new RRuntimeSourceEditorInput((RRuntimeSourceFragment)element);
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        block4: {
            try {
                if (input instanceof IFileEditorInput) {
                    return IDE.getEditorDescriptor((IFile)((IFileEditorInput)input).getFile(), (boolean)true, (boolean)false).getId();
                }
                if (!(input instanceof RRuntimeSourceEditorInput)) break block4;
                return "org.eclipse.statet.r.editors.R";
            }
            catch (PartInitException partInitException) {
                return null;
            }
        }
        return IDE.getEditorDescriptor((String)input.getName(), (boolean)true, (boolean)false).getId();
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        if (value instanceof RValue) {
            listener.detailComputed(value, ((RValue)value).getDetailString());
            return;
        }
        listener.detailComputed(value, null);
    }
}

