/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rtm.ggplot.ui.editors;

import java.util.List;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class AutoExpandListener
implements IValueChangeListener<Object>,
DisposeListener {
    private final ExpandableComposite composite;
    private int values;
    private List<? extends IObservable> observables;

    public AutoExpandListener(ExpandableComposite composite, List<? extends IObservable> observables) {
        this.composite = composite;
        this.observables = observables;
        for (IObservable iObservable : observables) {
            if (!(iObservable instanceof IObservableValue)) continue;
            IObservableValue observableValue = (IObservableValue)iObservable;
            if (observableValue.getValue() != null) {
                ++this.values;
            }
            observableValue.addValueChangeListener((IValueChangeListener)this);
        }
        if (this.values > 0) {
            this.composite.setExpanded(true);
        }
        this.composite.addDisposeListener((DisposeListener)this);
    }

    public void handleValueChange(ValueChangeEvent<?> event) {
        if (this.values > 0 || this.composite.isExpanded() || this.observables == null) {
            return;
        }
        if (event.diff.getOldValue() != null) {
            if (event.diff.getNewValue() == null) {
                --this.values;
            }
        } else if (event.diff.getNewValue() != null) {
            ++this.values;
        }
        if (this.values > 0 && UIAccess.isOkToUse((Control)this.composite)) {
            this.composite.setExpanded(true);
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        List<? extends IObservable> observables = this.observables;
        this.observables = null;
        if (observables != null) {
            for (IObservable iObservable : observables) {
                IObservableValue observableValue;
                if (!(iObservable instanceof IObservableValue) || (observableValue = (IObservableValue)iObservable).isDisposed()) continue;
                observableValue.removeValueChangeListener((IValueChangeListener)this);
            }
        }
    }
}

