/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.server.update;

import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.statet.internal.rhelp.server.update.REnvIndexConfig;
import org.eclipse.statet.internal.rhelp.server.update.REnvIndexer;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.concurrent.BasicThreadFactory;
import org.eclipse.statet.jcommons.concurrent.DaemonThreadFactory;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.rmi.RMIRegistryManager;
import org.eclipse.statet.rhelp.core.RHelpManager;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.REnvManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Profiles;
import org.springframework.stereotype.Component;

@Component
@NonNullByDefault
public class REnvIndexController {
    public static final TimeUnit TIME_UNIT = TimeUnit.MILLISECONDS;
    public static final String INDEX_AND_EXIT_PROFILE = "index-and-exit";
    private static final byte INDEX_AND_EXIT = 2;
    private final REnvManager rEnvManager;
    private final RHelpManager rHelpManager;
    private final int mode;
    private final REnvIndexConfig config;
    private final ThreadGroup threadGroup;
    private final ScheduledThreadPoolExecutor mainExecutorService;
    private final ExecutorService helperExecutorService;
    private final BasicThreadFactory monitorExecutorService;
    private final List<REnvIndexer> indexers;

    @Autowired
    public REnvIndexController(REnvManager rEnvManager, RHelpManager rHelpManager, REnvIndexConfig config, ApplicationContext appContext) {
        this.rEnvManager = (REnvManager)ObjectUtils.nonNullAssert((Object)rEnvManager);
        this.rHelpManager = (RHelpManager)ObjectUtils.nonNullAssert((Object)rHelpManager);
        this.mode = appContext.getEnvironment().acceptsProfiles(Profiles.of((String[])new String[]{INDEX_AND_EXIT_PROFILE})) ? 2 : 0;
        this.config = (REnvIndexConfig)ObjectUtils.nonNullAssert((Object)config);
        this.threadGroup = new ThreadGroup("REnvHelpIndex");
        this.mainExecutorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory(this.threadGroup, "MainPool"));
        this.helperExecutorService = new ThreadPoolExecutor(1, Math.max(2, Math.min(Runtime.getRuntime().availableProcessors(), 16)), 30L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), (ThreadFactory)new BasicThreadFactory(this.threadGroup, "HelperPool"));
        this.monitorExecutorService = new DaemonThreadFactory(this.threadGroup, "RLibPathsMonitor");
        ImList rEnvs = this.rEnvManager.list();
        ArrayList<REnvIndexer> list = new ArrayList<REnvIndexer>();
        for (REnv rEnv : rEnvs) {
            list.add(new REnvIndexer(this, rEnv));
        }
        this.indexers = list;
        this.start();
        if (this.mode == 2) {
            this.helperExecutorService.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public REnvManager getREnvManager() {
        return this.rEnvManager;
    }

    public RHelpManager getRHelpManager() {
        return this.rHelpManager;
    }

    ScheduledFuture<?> schedule(REnvIndexer rEnvIndexer, int delay) {
        return this.mainExecutorService.schedule((Runnable)rEnvIndexer, (long)delay, TIME_UNIT);
    }

    void startMonitor(Runnable runnable) {
        this.monitorExecutorService.newThread(runnable).start();
    }

    ExecutorService getHelperExecutorService() {
        return this.helperExecutorService;
    }

    public int getMonitorDelay() {
        return switch (this.mode) {
            case 2 -> -1;
            default -> this.config.getMonitorDelay();
        };
    }

    public int getPeriodicDelay() {
        return switch (this.mode) {
            case 2 -> -1;
            default -> this.config.getPeriodicDelay();
        };
    }

    private void start() {
        this.mainExecutorService.setCorePoolSize(Math.max(1, Math.min(Runtime.getRuntime().availableProcessors() * 2 / 3, this.indexers.size())));
        RMIRegistryManager.INSTANCE.setEmbeddedPrivateMode(false);
        for (REnvIndexer indexer : this.indexers) {
            indexer.start();
        }
    }

    @PreDestroy
    private void stop() {
        this.mainExecutorService.shutdown();
        for (REnvIndexer indexer : this.indexers) {
            indexer.stop();
        }
    }
}

