/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.util;

import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.statet.ecommons.ui.util.StatusLineMessageManager;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;

@NonNullByDefault
public class ViewActionUtil {
    private final IWorkbenchPart part;
    private final Control control;
    private final ISelectionProvider selectionProvider;
    private @Nullable Clipboard clipboard;
    private final StatusLineMessageManager statusLine;

    public ViewActionUtil(IViewPart part) {
        this.part = part;
        this.control = (Control)ObjectUtils.nonNullAssert((Object)((Control)part.getAdapter(Control.class)));
        IViewSite site = part.getViewSite();
        this.selectionProvider = (ISelectionProvider)ObjectUtils.nonNullAssert((Object)site.getSelectionProvider());
        this.statusLine = new StatusLineMessageManager(site.getActionBars().getStatusLineManager());
    }

    public IWorkbenchPart getWorkbenchPart() {
        return this.part;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public Control getControl() {
        return this.control;
    }

    public Clipboard getClipboard() {
        Clipboard clipboard = this.clipboard;
        if (clipboard == null) {
            this.clipboard = clipboard = new Clipboard(this.getControl().getDisplay());
        }
        return clipboard;
    }

    public StatusLineMessageManager getStatusLine() {
        return this.statusLine;
    }
}

