/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.preferences;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.statet.internal.ecommons.preferences.Messages;
import org.eclipse.statet.jcommons.lang.Disposable;

public class SettingsChangeNotifier
implements ISchedulingRule,
Disposable {
    private final ListenerList fManagers = new ListenerList();
    private final ListenerList fListeners = new ListenerList();
    private final Map<String, NotifyJob> fPendingJobs = new HashMap<String, NotifyJob>();
    private volatile boolean fIsDisposed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job getNotifyJob(String source, String[] groupIds) {
        if (this.fIsDisposed) {
            return null;
        }
        if (source == null) {
            source = "direct";
        }
        SettingsChangeNotifier settingsChangeNotifier = this;
        synchronized (settingsChangeNotifier) {
            NotifyJob job;
            block6: {
                job = this.fPendingJobs.get(source);
                if (job == null) break block6;
                job.addGroups(groupIds);
                return null;
            }
            job = new NotifyJob(source);
            this.fPendingJobs.put(source, job);
            job.addGroups(groupIds);
            return job;
        }
    }

    public boolean contains(ISchedulingRule rule) {
        return rule == this;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return rule == this;
    }

    public void addChangeListener(ChangeListener listener) {
        if (!this.fIsDisposed) {
            this.fListeners.add((Object)listener);
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        if (!this.fIsDisposed) {
            this.fListeners.remove((Object)listener);
        }
    }

    public void addManageListener(ManageListener listener) {
        if (!this.fIsDisposed) {
            this.fManagers.add((Object)listener);
        }
    }

    public void removeManageListener(ManageListener listener) {
        if (!this.fIsDisposed) {
            this.fManagers.remove((Object)listener);
        }
    }

    public void dispose() {
        this.fIsDisposed = true;
        this.fManagers.clear();
        this.fListeners.clear();
    }

    public static interface ChangeListener {
        public void settingsChanged(Set<String> var1);
    }

    public static interface ManageListener {
        public void beforeSettingsChangeNotification(Set<String> var1);

        public void afterSettingsChangeNotification(Set<String> var1);
    }

    private class NotifyJob
    extends Job {
        private final String fSource;
        private final Set<String> fChangedGroupIds;

        public NotifyJob(String source) {
            super(Messages.SettingsChangeNotifier_Job_title);
            this.fChangedGroupIds = new HashSet<String>();
            this.setPriority(20);
            this.setRule(SettingsChangeNotifier.this);
            this.fSource = source;
        }

        public void addGroups(String[] groupIds) {
            this.fChangedGroupIds.addAll(Arrays.asList(groupIds));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Object obj;
            Object[] listeners;
            Object[] managers;
            SettingsChangeNotifier settingsChangeNotifier = SettingsChangeNotifier.this;
            synchronized (settingsChangeNotifier) {
                managers = SettingsChangeNotifier.this.fManagers.getListeners();
                listeners = SettingsChangeNotifier.this.fListeners.getListeners();
                SettingsChangeNotifier.this.fPendingJobs.remove(this.fSource);
            }
            monitor.beginTask(Messages.SettingsChangeNotifier_Task_name, managers.length * 5 + listeners.length * 5);
            Object[] objectArray = managers;
            int n = managers.length;
            int n2 = 0;
            while (n2 < n) {
                obj = objectArray[n2];
                ((ManageListener)obj).beforeSettingsChangeNotification(this.fChangedGroupIds);
                monitor.worked(3);
                ++n2;
            }
            objectArray = listeners;
            n = listeners.length;
            n2 = 0;
            while (n2 < n) {
                obj = objectArray[n2];
                ((ChangeListener)obj).settingsChanged(this.fChangedGroupIds);
                monitor.worked(5);
                ++n2;
            }
            objectArray = managers;
            n = managers.length;
            n2 = 0;
            while (n2 < n) {
                obj = objectArray[n2];
                ((ManageListener)obj).afterSettingsChangeNotification(this.fChangedGroupIds);
                monitor.worked(2);
                ++n2;
            }
            return Status.OK_STATUS;
        }
    }
}

