/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.IOException;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.impl.AbstractNumericStore;
import org.eclipse.statet.rj.data.impl.ExternalizableRStore;

public class RNumericBFix64Store
extends AbstractNumericStore
implements ExternalizableRStore {
    public static final int SEGMENT_LENGTH = 0x10000000;
    private final long length;
    protected final double[][] realValues;

    public RNumericBFix64Store(long length) {
        this.length = length;
        this.realValues = RNumericBFix64Store.new2dDoubleArray(length, 0x10000000);
    }

    public RNumericBFix64Store(double[][] values) {
        this.length = RNumericBFix64Store.check2dArrayLength(values, 0x10000000);
        this.realValues = values;
    }

    public RNumericBFix64Store(RJIO io, long length) throws IOException {
        this.length = length;
        this.realValues = RNumericBFix64Store.new2dDoubleArray(length, 0x10000000);
        int i = 0;
        while (i < this.realValues.length) {
            io.readDoubleData(this.realValues[i], this.realValues[i].length);
            ++i;
        }
    }

    @Override
    public void writeExternal(RJIO io) throws IOException {
        int i = 0;
        while (i < this.realValues.length) {
            io.writeDoubleData(this.realValues[i], this.realValues[i].length);
            ++i;
        }
    }

    @Override
    protected final boolean isStructOnly() {
        return false;
    }

    @Override
    public final long getLength() {
        return this.length;
    }

    @Override
    public boolean isNA(int idx) {
        double v = this.realValues[idx / 0x10000000][idx % 0x10000000];
        return Double.isNaN(v) && (int)Double.doubleToRawLongBits(v) == 1954;
    }

    @Override
    public boolean isNA(long idx) {
        double v = this.realValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)];
        return Double.isNaN(v) && (int)Double.doubleToRawLongBits(v) == 1954;
    }

    @Override
    public void setNA(int idx) {
        this.realValues[idx / 0x10000000][idx % 0x10000000] = NA_numeric_DOUBLE;
    }

    @Override
    public void setNA(long idx) {
        this.realValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] = NA_numeric_DOUBLE;
    }

    @Override
    public boolean isNaN(int idx) {
        double v = this.realValues[idx / 0x10000000][idx % 0x10000000];
        return Double.isNaN(v) && (int)Double.doubleToRawLongBits(v) != 1954;
    }

    @Override
    public boolean isNaN(long idx) {
        double v = this.realValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)];
        return Double.isNaN(v) && (int)Double.doubleToRawLongBits(v) != 1954;
    }

    @Override
    public boolean isMissing(int idx) {
        return Double.isNaN(this.realValues[idx / 0x10000000][idx % 0x10000000]);
    }

    @Override
    public boolean isMissing(long idx) {
        return Double.isNaN(this.realValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)]);
    }

    @Override
    public double getNum(int idx) {
        return this.realValues[idx / 0x10000000][idx % 0x10000000];
    }

    @Override
    public double getNum(long idx) {
        return this.realValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)];
    }

    @Override
    public void setNum(int idx, double value) {
        this.realValues[idx / 0x10000000][idx % 0x10000000] = Double.isNaN(value) ? Double.NaN : value;
    }

    @Override
    public void setNum(long idx, double value) {
        this.realValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] = Double.isNaN(value) ? Double.NaN : value;
    }

    @Override
    public Double get(int idx) {
        if (idx < 0 || (long)idx >= this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        double v = this.realValues[idx / 0x10000000][idx % 0x10000000];
        return !Double.isNaN(v) || (int)Double.doubleToRawLongBits(v) != 1954 ? Double.valueOf(v) : null;
    }

    @Override
    public Double get(long idx) {
        if (idx < 0L || idx >= this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        double v = this.realValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)];
        return !Double.isNaN(v) || (int)Double.doubleToRawLongBits(v) != 1954 ? Double.valueOf(v) : null;
    }

    @Override
    public Double[] toArray() {
        int l = this.checkToArrayLength();
        @Nullable Double[] array = new Double[l];
        int i = 0;
        int k = 0;
        while (i < this.realValues.length) {
            double[] reals = this.realValues[i];
            int j = 0;
            while (j < reals.length) {
                double v = reals[j];
                if (!Double.isNaN(v) || (int)Double.doubleToRawLongBits(v) != 1954) {
                    array[k] = v;
                }
                ++j;
                ++k;
            }
            ++i;
        }
        return array;
    }
}

