/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.breakpoints;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.statet.r.debug.core.IRDebugTarget;
import org.eclipse.statet.r.debug.core.breakpoints.IRBreakpoint;

public abstract class RBreakpoint
extends Breakpoint
implements IRBreakpoint {
    public static final String INSTALL_COUNT_MARKER_ATTR = "org.eclipse.statet.r.resourceMarkers.InstallCountAttribute";
    private final Map<IRDebugTarget, IRBreakpoint.ITargetData> fInstalledTargets = new ConcurrentHashMap<IRDebugTarget, IRBreakpoint.ITargetData>();
    private final AtomicInteger fInstallCount = new AtomicInteger();

    protected RBreakpoint() {
        this.updateInstallCount(this.fInstallCount.get());
    }

    public String getModelIdentifier() {
        return "org.eclipse.statet.r.debugModels.R";
    }

    protected void register(boolean register) throws CoreException {
        DebugPlugin plugin = DebugPlugin.getDefault();
        if (plugin != null && register) {
            plugin.getBreakpointManager().addBreakpoint((IBreakpoint)this);
        } else {
            this.setRegistered(false);
        }
    }

    protected void update() {
    }

    @Override
    public IRBreakpoint.ITargetData registerTarget(IRDebugTarget target, IRBreakpoint.ITargetData data) {
        if (target == null) {
            throw new NullPointerException("target");
        }
        IRBreakpoint.ITargetData oldData = this.fInstalledTargets.put(target, data);
        if (oldData != null && oldData.isInstalled()) {
            if (data == null || !data.isInstalled()) {
                this.updateInstallCount(this.fInstallCount.decrementAndGet());
            }
        } else if (data != null && data.isInstalled()) {
            this.updateInstallCount(this.fInstallCount.incrementAndGet());
        }
        return oldData;
    }

    @Override
    public IRBreakpoint.ITargetData unregisterTarget(IRDebugTarget target) {
        if (target == null) {
            throw new NullPointerException("target");
        }
        IRBreakpoint.ITargetData oldData = this.fInstalledTargets.remove(target);
        if (oldData != null && oldData.isInstalled()) {
            this.updateInstallCount(this.fInstallCount.decrementAndGet());
        }
        return oldData;
    }

    private void updateInstallCount(int count) {
        try {
            this.ensureMarker().setAttribute(INSTALL_COUNT_MARKER_ATTR, count);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    @Override
    public IRBreakpoint.ITargetData getTargetData(IRDebugTarget target) {
        return this.fInstalledTargets.get(target);
    }

    @Override
    public boolean isInstalled() throws CoreException {
        return this.fInstallCount.get() > 0;
    }
}

