/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.console.ui.snippets;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.statet.ecommons.ui.util.MenuUtils;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.r.console.ui.RConsoleUIPlugin;
import org.eclipse.statet.internal.r.console.ui.snippets.RSnippets;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

public class SubmitLastRSnippetHandler
extends AbstractHandler
implements IElementUpdater {
    private final RSnippets snippets = RConsoleUIPlugin.getInstance().getRSnippets();

    public void updateElement(UIElement element, Map parameters) {
        WorkbenchUIUtils.aboutToUpdateCommandsElements((IHandler2)this, (UIElement)element);
        try {
            Template lastTemplate;
            TemplateStore templateStore = this.snippets.getTemplateStore();
            String name = this.snippets.getLastSnippet();
            Template template = lastTemplate = name != null ? templateStore.findTemplate(name) : null;
            if (lastTemplate != null) {
                element.setTooltip(lastTemplate.getDescription());
            } else {
                element.setTooltip(null);
            }
        }
        finally {
            WorkbenchUIUtils.finalizeUpdateCommandsElements((IHandler2)this);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Widget widget;
        Template template;
        String name = this.snippets.getLastSnippet();
        Template template2 = template = name != null ? this.snippets.getTemplateStore().findTemplate(name) : null;
        if (template != null) {
            this.snippets.run(template, event);
            return null;
        }
        Object trigger = event.getTrigger();
        if (trigger instanceof Event && (widget = ((Event)trigger).widget) instanceof ToolItem) {
            ToolItem ti = (ToolItem)widget;
            MenuManager menuManager = new MenuManager();
            Menu menu = menuManager.createContextMenu((Control)ti.getParent());
            MenuUtils.registerOneWayMenu((MenuManager)menuManager, (String)"org.eclipse.statet.r.menus.RunRSnippetMain");
            MenuUtils.setPullDownPosition((Menu)menu, (ToolItem)ti);
            menu.setVisible(true);
        }
        return null;
    }
}

