/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.sort;

import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.layer.ForwardLayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.layer.cell.ForwardLayerCell;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCellDim;
import org.eclipse.statet.ecommons.waltable.persistence.IPersistable;
import org.eclipse.statet.ecommons.waltable.sort.ISortModel;
import org.eclipse.statet.ecommons.waltable.sort.SortDirection;
import org.eclipse.statet.ecommons.waltable.sort.SortStatePersistor;
import org.eclipse.statet.ecommons.waltable.sort.config.DefaultSortConfiguration;

public class SortHeaderLayer<T>
extends ForwardLayer
implements IPersistable {
    private final ISortModel sortModel;

    public SortHeaderLayer(ILayer underlyingLayer, ISortModel sortModel) {
        this(underlyingLayer, sortModel, true);
    }

    public SortHeaderLayer(ILayer underlyingLayer, ISortModel sortModel, boolean useDefaultConfiguration) {
        super(underlyingLayer);
        this.sortModel = sortModel;
        this.registerPersistable(new SortStatePersistor(sortModel));
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultSortConfiguration());
        }
    }

    public ISortModel getSortModel() {
        return this.sortModel;
    }

    @Override
    protected ILayerCell createCell(ILayerCellDim hDim, ILayerCellDim vDim, ILayerCell underlyingCell) {
        return new ForwardLayerCell(this, hDim, vDim, underlyingCell){

            @Override
            public LabelStack getConfigLabels() {
                LabelStack configLabels = super.getConfigLabels();
                long id = this.getDim(Orientation.HORIZONTAL).getId();
                if (SortHeaderLayer.this.sortModel.isSorted(id)) {
                    String sortConfig = "SORT_SEQ_" + SortHeaderLayer.this.sortModel.getSortOrder(id);
                    configLabels.addLabelOnTop(sortConfig);
                    SortDirection sortDirection = SortHeaderLayer.this.sortModel.getSortDirection(id);
                    switch (sortDirection) {
                        case ASC: {
                            configLabels.addLabelOnTop("SORT_UP");
                            break;
                        }
                        case DESC: {
                            configLabels.addLabelOnTop("SORT_DOWN");
                        }
                    }
                }
                return configLabels;
            }
        };
    }
}

