/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.viewport;

import org.eclipse.statet.ecommons.waltable.command.AbstractLayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.coordinate.Direction;
import org.eclipse.statet.ecommons.waltable.viewport.IViewportDim;
import org.eclipse.statet.ecommons.waltable.viewport.ScrollPageCommand;
import org.eclipse.statet.ecommons.waltable.viewport.ViewportLayer;

public class ScrollPageCommandHandler
extends AbstractLayerCommandHandler<ScrollPageCommand> {
    private final ViewportLayer viewportLayer;

    public ScrollPageCommandHandler(ViewportLayer viewportLayer) {
        this.viewportLayer = viewportLayer;
    }

    @Override
    public Class<ScrollPageCommand> getCommandClass() {
        return ScrollPageCommand.class;
    }

    @Override
    protected boolean doCommand(ScrollPageCommand command) {
        Direction direction = command.getDirection();
        IViewportDim dim = this.viewportLayer.getDim(direction.getOrientation());
        if (direction.isBackward()) {
            dim.scrollBackwardByPage();
        } else {
            dim.scrollForwardByPage();
        }
        return true;
    }
}

