/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.IOException;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.impl.AbstractIntegerStore;
import org.eclipse.statet.rj.data.impl.ExternalizableRStore;

public class RIntegerFix64Store
extends AbstractIntegerStore
implements ExternalizableRStore {
    public static final int SEGMENT_LENGTH = 0x10000000;
    private final long length;
    protected final int[][] intValues;

    public RIntegerFix64Store(long length) {
        this.length = length;
        this.intValues = RIntegerFix64Store.new2dIntArray(length, 0x10000000);
    }

    public RIntegerFix64Store(int[][] values) {
        this.length = RIntegerFix64Store.check2dArrayLength(values, 0x10000000);
        this.intValues = values;
    }

    public RIntegerFix64Store(RJIO io, long length) throws IOException {
        this.length = length;
        this.intValues = RIntegerFix64Store.new2dIntArray(length, 0x10000000);
        int i = 0;
        while (i < this.intValues.length) {
            io.readIntData(this.intValues[i], this.intValues[i].length);
            ++i;
        }
    }

    @Override
    public void writeExternal(RJIO io) throws IOException {
        int i = 0;
        while (i < this.intValues.length) {
            io.writeIntData(this.intValues[i], this.intValues[i].length);
            ++i;
        }
    }

    @Override
    protected final boolean isStructOnly() {
        return false;
    }

    @Override
    public final long getLength() {
        return this.length;
    }

    @Override
    public boolean isNA(int idx) {
        return this.intValues[idx / 0x10000000][idx % 0x10000000] == Integer.MIN_VALUE;
    }

    @Override
    public boolean isNA(long idx) {
        return this.intValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] == Integer.MIN_VALUE;
    }

    @Override
    public void setNA(int idx) {
        this.intValues[idx / 0x10000000][idx % 0x10000000] = Integer.MIN_VALUE;
    }

    @Override
    public void setNA(long idx) {
        this.intValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] = Integer.MIN_VALUE;
    }

    @Override
    public boolean isMissing(int idx) {
        return this.intValues[idx / 0x10000000][idx % 0x10000000] == Integer.MIN_VALUE;
    }

    @Override
    public boolean isMissing(long idx) {
        return this.intValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] == Integer.MIN_VALUE;
    }

    @Override
    public int getInt(int idx) {
        return this.intValues[idx / 0x10000000][idx % 0x10000000];
    }

    @Override
    public int getInt(long idx) {
        return this.intValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)];
    }

    @Override
    public void setInt(int idx, int value) {
        this.intValues[idx / 0x10000000][idx % 0x10000000] = value;
    }

    @Override
    public void setInt(long idx, int value) {
        this.intValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] = value;
    }

    @Override
    public Integer get(int idx) {
        if (idx < 0 || (long)idx >= this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        int v = this.intValues[idx / 0x10000000][idx % 0x10000000];
        return v != Integer.MIN_VALUE ? Integer.valueOf(v) : null;
    }

    @Override
    public Integer get(long idx) {
        if (idx < 0L || idx >= this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        int v = this.intValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)];
        return v != Integer.MIN_VALUE ? Integer.valueOf(v) : null;
    }

    @Override
    public Integer[] toArray() {
        int l = this.checkToArrayLength();
        @Nullable Integer[] array = new Integer[l];
        int i = 0;
        int destIdx = 0;
        while (i < this.intValues.length) {
            int[] ints = this.intValues[i];
            int j = 0;
            while (j < ints.length) {
                int v = ints[j];
                if (v != Integer.MIN_VALUE) {
                    array[destIdx] = v;
                }
                ++j;
                ++destIdx;
            }
            ++i;
        }
        return array;
    }

    @Override
    public long indexOfNA(long fromIdx) {
        if (fromIdx < 0L) {
            fromIdx = 0L;
        }
        int i = (int)(fromIdx / 0x10000000L);
        int j = (int)(fromIdx % 0x10000000L);
        while (i < this.intValues.length) {
            int[] ints = this.intValues[i];
            while (j < ints.length) {
                if (ints[i] != Integer.MIN_VALUE) continue;
                return (long)i * 0x10000000L + (long)j;
            }
            ++i;
            j = 0;
        }
        return -1L;
    }

    @Override
    public final long indexOf(int integer, long fromIdx) {
        if (integer == Integer.MIN_VALUE) {
            return -1L;
        }
        if (fromIdx < 0L) {
            fromIdx = 0L;
        }
        int i = (int)(fromIdx / 0x10000000L);
        int j = (int)(fromIdx % 0x10000000L);
        while (i < this.intValues.length) {
            int[] ints = this.intValues[i];
            while (j < ints.length) {
                if (ints[i] != integer) continue;
                return (long)i * 0x10000000L + (long)j;
            }
            ++i;
            j = 0;
        }
        return -1L;
    }
}

