/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.core;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.net.resourcemapping.core.IResourceMapping;
import org.eclipse.statet.ecommons.net.resourcemapping.core.IResourceMappingManager;
import org.eclipse.statet.ecommons.net.resourcemapping.core.ResourceMappingOrder;
import org.eclipse.statet.internal.nico.core.NicoCorePlugin;
import org.eclipse.statet.internal.nico.core.ResourceMapping;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ResourceMappingManager
implements IResourceMappingManager {
    private static final String QUALIFIER = "org.eclipse.statet.nico.core/resoursemappings";
    private static final String LOCAL_KEY = "local.path";
    private static final String HOST_KEY = "host.name";
    private static final String REMOTE_KEY = "remote.path";
    public static final Comparator<IResourceMapping> DEFAULT_COMPARATOR = new Comparator<IResourceMapping>(){

        @Override
        public int compare(IResourceMapping o1, IResourceMapping o2) {
            int diff = o1.getHost().compareTo(o2.getHost());
            if (diff != 0) {
                return diff;
            }
            return o1.getRemotePath().toPortableString().compareTo(o2.getRemotePath().toPortableString());
        }
    };
    private static final Comparator<IResourceMapping> LOCAL_COMPARATOR = new Comparator<IResourceMapping>(){

        @Override
        public int compare(IResourceMapping o1, IResourceMapping o2) {
            return -o1.getFileStore().toURI().compareTo(o2.getFileStore().toURI());
        }
    };
    private static final Comparator<IResourceMapping> REMOTE_COMPARATOR = new Comparator<IResourceMapping>(){

        @Override
        public int compare(IResourceMapping o1, IResourceMapping o2) {
            return -o1.getRemotePath().toPortableString().compareTo(o2.getRemotePath().toPortableString());
        }
    };
    private ImList<ResourceMapping> list;
    private Map<String, List<IResourceMapping>[]> mappingsByHost;
    private final UpdateJob updateJob = new UpdateJob();

    public ResourceMappingManager() {
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ResourceMappingManager resourceMappingManager = this;
        synchronized (resourceMappingManager) {
            this.list = null;
            this.updateJob.cancel();
        }
    }

    public List<ResourceMapping> getList() {
        return this.list;
    }

    public List<IResourceMapping> getMappingsFor(String hostAddress, ResourceMappingOrder order) {
        List<IResourceMapping>[] lists;
        Map<String, List<IResourceMapping>[]> byHost = this.mappingsByHost;
        if (byHost != null && (lists = byHost.get(hostAddress)) != null) {
            return lists[order != null ? order.ordinal() : 0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        try {
            String[] names;
            ArrayList<ResourceMapping> list = new ArrayList<ResourceMapping>();
            IEclipsePreferences rootNode = InstanceScope.INSTANCE.getNode(QUALIFIER);
            String[] stringArray = names = rootNode.childrenNames();
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                ResourceMapping mapping = this.read(rootNode.node(name));
                if (mapping != null) {
                    list.add(mapping);
                }
                ++n2;
            }
            Object[] array = list.toArray(new ResourceMapping[list.size()]);
            Arrays.sort(array, DEFAULT_COMPARATOR);
            ResourceMappingManager resourceMappingManager = this;
            synchronized (resourceMappingManager) {
                this.list = ImCollections.newList((Object[])array);
                this.updateJob.cancel();
                this.updateJob.schedule();
            }
        }
        catch (BackingStoreException e) {
            NicoCorePlugin.logError(-1, "Failed to load resource mappings.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMappings(List<ResourceMapping> list) {
        ImList newMappings = ImCollections.toList(list, DEFAULT_COMPARATOR);
        try {
            String id;
            IEclipsePreferences rootNode = InstanceScope.INSTANCE.getNode(QUALIFIER);
            LinkedList names = new LinkedList(ImCollections.newList((Object[])rootNode.childrenNames()));
            LinkedList todo = new LinkedList(newMappings);
            int maxIdx = 0;
            Iterator iter = todo.iterator();
            while (iter.hasNext()) {
                ResourceMapping mapping = (ResourceMapping)iter.next();
                id = mapping.getId();
                if (id == null) continue;
                try {
                    int idx = Integer.parseInt(id);
                    if (idx > maxIdx) {
                        maxIdx = idx;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                iter.remove();
                names.remove(id);
                this.write(rootNode.node(id), mapping);
            }
            for (ResourceMapping mapping : todo) {
                id = Integer.toString(++maxIdx);
                mapping.setId(id);
                names.remove(id);
                this.write(rootNode.node(id), mapping);
            }
            for (String name : names) {
                if (!rootNode.nodeExists(name)) continue;
                Preferences node = rootNode.node(name);
                node.removeNode();
            }
            rootNode.flush();
            ResourceMappingManager resourceMappingManager = this;
            synchronized (resourceMappingManager) {
                this.list = newMappings;
                this.updateJob.cancel();
                this.updateJob.schedule();
            }
        }
        catch (BackingStoreException e) {
            NicoCorePlugin.logError(-1, "Failed to save resource mappings.", e);
        }
    }

    protected ResourceMapping read(Preferences node) {
        String id = node.name();
        String local = node.get(LOCAL_KEY, null);
        String host = node.get(HOST_KEY, null);
        String remote = node.get(REMOTE_KEY, null);
        if (local != null && host != null && remote != null) {
            try {
                return new ResourceMapping(id, local, host, remote);
            }
            catch (CoreException e) {
                NicoCorePlugin.logError(-1, NLS.bind((String)"Failed to load resource mapping: ''{0}''.", (Object)id), e);
            }
        }
        return null;
    }

    protected void write(Preferences node, ResourceMapping mapping) {
        node.put(LOCAL_KEY, mapping.getLocalText());
        node.put(HOST_KEY, mapping.getHost());
        node.put(REMOTE_KEY, mapping.getRemotePath().toString());
    }

    public List<IResourceMapping> getResourceMappingsFor(String hostAddress, ResourceMappingOrder order) {
        List<IResourceMapping> mappings = this.getMappingsFor(hostAddress, order);
        if (mappings != null) {
            return mappings;
        }
        return Collections.emptyList();
    }

    public IFileStore mapRemoteResourceToFileStore(String hostAddress, IPath remotePath, IPath relativeBasePath) {
        if (!remotePath.isAbsolute()) {
            if (relativeBasePath == null) {
                return null;
            }
            remotePath = relativeBasePath.append(remotePath);
        }
        List<IResourceMapping> mappings = this.getResourceMappingsFor(hostAddress, ResourceMappingOrder.REMOTE);
        for (IResourceMapping mapping : mappings) {
            IPath remoteBase = mapping.getRemotePath();
            if (!remoteBase.isPrefixOf(remotePath)) continue;
            IPath subPath = remotePath.removeFirstSegments(remoteBase.segmentCount());
            IFileStore localBaseStore = mapping.getFileStore();
            return localBaseStore.getFileStore(subPath);
        }
        return null;
    }

    public IPath mapFileStoreToRemoteResource(String hostAddress, IFileStore fileStore) {
        List<IResourceMapping> mappings = this.getResourceMappingsFor(hostAddress, ResourceMappingOrder.LOCAL);
        for (IResourceMapping mapping : mappings) {
            Path fileStorePath;
            Path localBasePath;
            IFileStore localBaseStore = mapping.getFileStore();
            if (localBaseStore.equals(fileStore)) {
                return mapping.getRemotePath();
            }
            if (!localBaseStore.isParentOf(fileStore) || !(localBasePath = new Path(localBaseStore.toURI().getPath())).isPrefixOf((IPath)(fileStorePath = new Path(fileStore.toURI().getPath())))) continue;
            IPath subPath = fileStorePath.removeFirstSegments(localBasePath.segmentCount());
            IPath remotePath = mapping.getRemotePath();
            return remotePath.append(subPath);
        }
        return null;
    }

    private class UpdateJob
    extends Job {
        UpdateJob() {
            super("Update Resource Mappings");
            this.setPriority(40);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            ImList list = ResourceMappingManager.this.list;
            if (list == null) {
                return Status.OK_STATUS;
            }
            SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)(list.size() + 1));
            try {
                MultiStatus status = new MultiStatus("org.eclipse.statet.nico.core", 0, "Update Resource Mapping", null);
                HashMap<String, List[]> mappingsByHost = new HashMap<String, List[]>();
                for (ResourceMapping mapping : list) {
                    try {
                        try {
                            InetAddress[] addresses;
                            mapping.resolve();
                            InetAddress[] inetAddressArray = addresses = mapping.getHostAddresses();
                            int n = addresses.length;
                            int n2 = 0;
                            while (n2 < n) {
                                InetAddress inetAddress = inetAddressArray[n2];
                                String host = inetAddress.getHostAddress();
                                List[] mappings = (List[])mappingsByHost.get(host);
                                if (mappings == null) {
                                    List[] listArray = new List[2];
                                    listArray[0] = new ArrayList();
                                    mappings = listArray;
                                    mappingsByHost.put(host, mappings);
                                }
                                mappings[0].add(mapping);
                                ++n2;
                            }
                        }
                        catch (UnknownHostException e) {
                            status.add((IStatus)new Status(1, "org.eclipse.statet.nico.core", "Unknown host: " + e.getMessage(), (Throwable)e));
                            m.worked(1);
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        m.worked(1);
                        throw throwable;
                    }
                    m.worked(1);
                }
                for (List[] lists : mappingsByHost.values()) {
                    List unsorted = lists[0];
                    lists[ResourceMappingOrder.LOCAL.ordinal()] = ImCollections.toList((Collection)unsorted, (Comparator)LOCAL_COMPARATOR);
                    lists[ResourceMappingOrder.REMOTE.ordinal()] = ImCollections.toList((Collection)unsorted, (Comparator)REMOTE_COMPARATOR);
                }
                ResourceMappingManager resourceMappingManager = ResourceMappingManager.this;
                synchronized (resourceMappingManager) {
                    if (ResourceMappingManager.this.list == list) {
                        ResourceMappingManager.this.mappingsByHost = mappingsByHost;
                    }
                }
                MultiStatus multiStatus = status;
                return multiStatus;
            }
            finally {
                m.done();
            }
        }
    }
}

