/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.actions;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.statet.ecommons.ui.components.SearchText;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class SearchContributionItem
extends ContributionItem {
    public static final int VIEW_TOOLBAR = 0x10000000;
    private final int fOptions;
    private SearchText fControl;
    private ToolItem fTextItem;
    private String fToolTipText;
    private Composite fSizeControl;
    private Control fResultControl;
    private final boolean fUpdateWhenTyping;
    private final Runnable fSizeCheckRunnable = new Runnable(){

        @Override
        public void run() {
            SearchContributionItem.this.fSizeCheckScheduled = false;
            SearchContributionItem.this.resize();
        }
    };
    private boolean fSizeCheckScheduled;

    public SearchContributionItem(String id, int options) {
        this(id, options, false);
    }

    public SearchContributionItem(String id, int options, boolean updateWhenTyping) {
        super(id);
        this.fOptions = options;
        this.fUpdateWhenTyping = updateWhenTyping;
    }

    public SearchText getSearchText() {
        return this.fControl;
    }

    public void setResultControl(Control control) {
        this.fResultControl = control;
    }

    public void setToolTip(String text) {
        this.fToolTipText = text;
    }

    public void setSizeControl(Composite control) {
        this.fSizeControl = control;
        this.fSizeControl.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                SearchContributionItem.this.resize();
            }
        });
    }

    public void resize() {
        if (this.fTextItem != null && !this.fTextItem.isDisposed() && this.fSizeControl != null) {
            int width;
            int viewWidth = this.fSizeControl.getClientArea().width;
            if (viewWidth <= 0) {
                return;
            }
            ToolBar toolBar = this.fTextItem.getParent();
            Composite toolBarParent = toolBar.getParent();
            int toolBarWidth = toolBar.computeSize((int)-1, (int)-1).x;
            int currentWidth = this.fTextItem.getWidth();
            int minWidth = LayoutUtils.hintWidth(this.fControl.getTextControl(), 8);
            int corr = toolBarWidth - currentWidth;
            if ((this.fOptions & 0x10000000) != 0) {
                if (WorkbenchUIUtils.IS_E4) {
                    Layout layout = toolBarParent.getLayout();
                    if (layout instanceof RowLayout && ((RowLayout)layout).type == 256) {
                        Control[] children = toolBarParent.getChildren();
                        int i = 0;
                        while (i < children.length) {
                            if (children[i] != toolBar) {
                                corr += children[i].getSize().x;
                            }
                            ++i;
                        }
                        corr += (children.length - 1) * ((RowLayout)layout).spacing;
                    }
                } else {
                    corr += 18;
                }
            }
            if ((width = Math.min(310, Math.max(minWidth, viewWidth - (corr += 16)))) == currentWidth) {
                return;
            }
            this.fTextItem.setWidth(width);
            toolBar.layout(new Control[]{this.fControl});
            toolBarParent.layout(true, true);
            if (WorkbenchUIUtils.IS_E4) {
                toolBarParent.pack(true);
            }
        }
    }

    private void scheduleSizeCheck() {
        if (!this.fSizeCheckScheduled && this.fTextItem != null && !this.fTextItem.isDisposed()) {
            this.fSizeCheckScheduled = true;
            this.fTextItem.getDisplay().asyncExec(this.fSizeCheckRunnable);
        }
    }

    public void fill(ToolBar parent, int index) {
        this.fControl = new SearchText((Composite)parent);
        this.fControl.addListener(this.createSearchTextListener());
        SWTListener swtListener = new SWTListener();
        this.fControl.addListener(11, swtListener);
        this.fControl.setToolTipText(this.fToolTipText);
        this.fTextItem = new ToolItem(parent, 2, index);
        this.fTextItem.setControl((Control)this.fControl);
        this.fTextItem.setToolTipText(this.fToolTipText);
        this.fTextItem.setWidth(310);
    }

    public Control create(Composite parent) {
        this.fControl = new SearchText(parent);
        this.fControl.addListener(this.createSearchTextListener());
        SWTListener swtListener = new SWTListener();
        this.fControl.addListener(11, swtListener);
        this.fControl.setToolTipText(this.fToolTipText);
        return this.fControl;
    }

    protected SearchText.Listener createSearchTextListener() {
        return new SearchText.Listener(){

            @Override
            public void textChanged(boolean user) {
                if (SearchContributionItem.this.fUpdateWhenTyping || !user) {
                    SearchContributionItem.this.search();
                }
            }

            @Override
            public void okPressed() {
                SearchContributionItem.this.search();
            }

            @Override
            public void downPressed() {
                SearchContributionItem.this.selectFirst();
            }
        };
    }

    protected void search() {
    }

    protected void selectFirst() {
        if (this.fResultControl instanceof Table) {
            int idx;
            Table table = (Table)this.fResultControl;
            table.setFocus();
            if (table.getSelectionCount() == 0 && (idx = table.getTopIndex()) >= 0) {
                table.setSelection(idx);
            }
        } else if (this.fResultControl instanceof Tree) {
            TreeItem item;
            Tree table = (Tree)this.fResultControl;
            table.setFocus();
            if (table.getSelectionCount() == 0 && (item = table.getTopItem()) != null) {
                table.setSelection(item);
            }
        }
    }

    public String getText() {
        return this.fControl.getText();
    }

    public void show() {
        if (!UIAccess.isOkToUse((Control)this.fControl)) {
            return;
        }
        this.fControl.setFocus();
    }

    private class SWTListener
    implements Listener {
        private SWTListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 11: {
                    SearchContributionItem.this.scheduleSizeCheck();
                    return;
                }
            }
        }
    }
}

