/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.datafilterview;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.r.ui.datafilter.IFilterListener;
import org.eclipse.statet.internal.r.ui.datafilter.VariableFilter;
import org.eclipse.statet.internal.r.ui.datafilterview.VariableComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.services.IServiceLocator;

public abstract class FilterClient
extends Composite
implements IFilterListener {
    protected static final String SELECT_ALL_COMMAND_ID = "org.eclipse.ui.edit.selectAll";
    protected static final String REMOVE_COMMAND_ID = "org.eclipse.ui.edit.delete";
    protected static final String REMOVE_ALL_HANDLER_COMMAND_ID = "RemoveAll";
    protected static final String REMOVE_UNCHECKED_HANDLER_ID = "RemoveUnchecked";
    private DataBindingSupport cataBinding;
    private Listener resizeListener;

    public FilterClient(VariableComposite parent) {
        super((Composite)parent, 0);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FilterClient.this.onDispose();
            }
        });
    }

    public VariableComposite getParent() {
        return (VariableComposite)super.getParent();
    }

    public abstract VariableFilter getFilter();

    protected void init(int numColumns) {
        this.getParent().setClient((Control)this);
        this.setLayout((Layout)LayoutUtils.newCompositeGrid((int)numColumns));
        this.addWidgets();
        LayoutUtils.addSmallFiller((Composite)this, (boolean)false);
        this.initActions(this.getParent().getContainer().getServiceLocator());
        this.initBindings();
        this.updateInput();
    }

    protected abstract void addWidgets();

    protected abstract void initActions(IServiceLocator var1);

    @Override
    public void filterChanged() {
        if (this.isDisposed()) {
            return;
        }
        this.updateInput();
    }

    protected abstract void updateInput();

    protected void initBindings() {
        this.cataBinding = new DataBindingSupport((Control)this);
        this.addBindings(this.cataBinding);
        this.cataBinding.getContext().updateTargets();
    }

    protected void addBindings(DataBindingSupport db) {
    }

    protected DataBindingSupport getDataBinding() {
        return this.cataBinding;
    }

    protected void installResizeListener() {
        if (this.resizeListener == null) {
            this.resizeListener = new Listener(){

                public void handleEvent(Event event) {
                    if (FilterClient.this.updateLayout()) {
                        FilterClient.this.getParent().layout(new Control[]{FilterClient.this});
                    }
                }
            };
            this.getParent().getContainer().getVariableComposite().addListener(11, this.resizeListener);
        }
    }

    protected boolean updateLayout() {
        return false;
    }

    protected boolean updateLayout(TableViewer viewer, int count) {
        GridData data = new GridData(4, 0x1000000, true, false, ((GridLayout)this.getLayout()).numColumns, 1);
        if (count == 0) {
            data.exclude = true;
        } else {
            data.heightHint = LayoutUtils.hintHeight((Table)viewer.getTable(), (int)count, (boolean)false);
            int max = Math.max(5 * viewer.getTable().getItemHeight(), this.getParent().getContainer().getVariableComposite().getClientArea().height - this.getMinHeightPadding());
            if (data.heightHint > max) {
                data.heightHint = max;
            }
            this.installResizeListener();
        }
        Control control = viewer.getControl();
        GridData oldData = (GridData)control.getLayoutData();
        if (oldData == null || oldData.exclude != data.exclude || oldData.heightHint != data.heightHint) {
            control.setVisible(!data.exclude);
            control.setLayoutData((Object)data);
            return true;
        }
        return false;
    }

    protected int getMinHeightPadding() {
        return 20 + 8 * LayoutUtils.defaultVSpacing();
    }

    public void layout(boolean changed, boolean all) {
        super.layout(changed |= this.updateLayout(), all);
    }

    public void layout(Control[] changed, int flags) {
        if (this.updateLayout()) {
            flags |= 2;
        }
        super.layout(changed, flags);
    }

    protected void onDispose() {
        Listener listener = this.resizeListener;
        if (listener != null) {
            this.resizeListener = null;
            this.getParent().getContainer().getVariableComposite().removeListener(11, listener);
        }
    }
}

