/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.internal.ltk.ui.LTKUIPlugin;
import org.eclipse.statet.ltk.ui.sourceediting.EditorInformationProvider;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditorAddon;
import org.eclipse.statet.ltk.ui.sourceediting.MultiContentSectionInformationProvider;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfiguration;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.MultiContentSectionQuickAssistProcessor;
import org.eclipse.ui.statushandlers.StatusManager;

public class MultiContentSectionSourceViewerConfiguration
extends SourceEditorViewerConfiguration {
    private final DocContentSections sections;
    private SourceEditorViewerConfiguration primaryConfig;
    private final Map<String, SourceEditorViewerConfiguration> secondaryConfigs = new IdentityHashMap<String, SourceEditorViewerConfiguration>(8);
    private final Map<String, Integer> secondaryConfigStates = new IdentityHashMap<String, Integer>();

    public MultiContentSectionSourceViewerConfiguration(DocContentSections sections, int flags, ISourceEditor sourceEditor) {
        super(sections, flags, sourceEditor);
        this.sections = sections;
    }

    protected void registerConfig(String sectionType, SourceEditorViewerConfiguration config) {
        if (sectionType == null) {
            throw new NullPointerException("sectionType");
        }
        if (sectionType == this.sections.getPrimaryType()) {
            this.primaryConfig = config;
        } else {
            this.secondaryConfigs.put(sectionType, config);
        }
    }

    protected final SourceEditorViewerConfiguration getConfig(String sectionType) {
        if (sectionType == this.sections.getPrimaryType()) {
            return this.primaryConfig;
        }
        return this.secondaryConfigs.get(sectionType);
    }

    protected final SourceEditorViewerConfiguration getConfigSafe(String sectionType) {
        if (sectionType == null || sectionType == this.sections.getPrimaryType()) {
            return this.primaryConfig;
        }
        SourceEditorViewerConfiguration config = this.secondaryConfigs.get(sectionType);
        return config != null ? config : this.primaryConfig;
    }

    protected boolean checkInit(String type) {
        Integer state;
        if (type == null) {
            return false;
        }
        SourceEditorViewerConfiguration config = this.secondaryConfigs.get(type);
        if (config != null && (state = this.secondaryConfigStates.put(type, 1)) == null) {
            config.initPresentationReconciler(this.getPresentationReconciler());
            ContentAssist contentAssist = this.getContentAssist();
            if (contentAssist instanceof LazyContentAssist) {
                config.initContentAssist(contentAssist);
            }
            return true;
        }
        return false;
    }

    @Override
    public List<ISourceEditorAddon> getAddOns() {
        List<ISourceEditorAddon> addOns = super.getAddOns();
        addOns.addAll(this.primaryConfig.getAddOns());
        for (SourceEditorViewerConfiguration config : this.secondaryConfigs.values()) {
            addOns.addAll(config.getAddOns());
        }
        return addOns;
    }

    @Override
    public void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
        for (SourceEditorViewerConfiguration config : this.secondaryConfigs.values()) {
            config.handleSettingsChanged(groupIds, options);
        }
        this.primaryConfig.handleSettingsChanged(groupIds, options);
        super.handleSettingsChanged(groupIds, options);
    }

    @Override
    protected IPresentationReconciler createPresentationReconciler() {
        LazyPresentationReconciler reconciler = new LazyPresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(null));
        this.initPresentationReconciler(reconciler);
        return reconciler;
    }

    @Override
    protected void initPresentationReconciler(PresentationReconciler reconciler) {
        this.primaryConfig.initPresentationReconciler(reconciler);
    }

    @Override
    public int getTabWidth(ISourceViewer sourceViewer) {
        SourceEditorViewerConfiguration config = this.getConfigSafe(null);
        return config.getTabWidth(sourceViewer);
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        SourceEditorViewerConfiguration config = this.getConfigSafe(this.sections.getTypeByPartition(contentType));
        return config.getDefaultPrefixes(sourceViewer, contentType);
    }

    @Override
    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        SourceEditorViewerConfiguration config = this.getConfig(this.sections.getTypeByPartition(contentType));
        if (config != null) {
            return config.getIndentPrefixes(sourceViewer, contentType);
        }
        return null;
    }

    @Override
    public boolean isSmartInsertSupported() {
        SourceEditorViewerConfiguration config = this.getConfigSafe(null);
        return config.isSmartInsertSupported();
    }

    @Override
    public boolean isSmartInsertByDefault() {
        SourceEditorViewerConfiguration config = this.getConfigSafe(null);
        return config.isSmartInsertByDefault();
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        SourceEditorViewerConfiguration config = this.getConfig(this.sections.getTypeByPartition(contentType));
        if (config != null) {
            return config.getAutoEditStrategies(sourceViewer, contentType);
        }
        return null;
    }

    @Override
    protected ContentAssist createContentAssistant(ISourceViewer sourceViewer) {
        if (this.getSourceEditor() != null) {
            LazyContentAssist assistant = new LazyContentAssist();
            assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(null));
            assistant.setRestoreCompletionProposalSize(DialogUtils.getDialogSettings((Plugin)LTKUIPlugin.getInstance(), (String)"ContentAssist.Proposal.size"));
            this.initContentAssist(assistant);
            return assistant;
        }
        return null;
    }

    @Override
    protected void initContentAssist(ContentAssist assistant) {
        this.primaryConfig.initContentAssist(assistant);
        if (!this.secondaryConfigStates.isEmpty()) {
            for (String type : this.secondaryConfigStates.keySet()) {
                this.secondaryConfigs.get(type).initContentAssist(assistant);
            }
        }
    }

    @Override
    protected IQuickAssistProcessor createQuickAssistProcessor() {
        return new MultiContentSectionQuickAssistProcessor(this.sections){

            @Override
            protected IQuickAssistProcessor createProcessor(String sectionType) {
                SourceEditorViewerConfiguration config = MultiContentSectionSourceViewerConfiguration.this.getConfig(sectionType);
                if (config != null) {
                    return config.createQuickAssistProcessor();
                }
                return null;
            }
        };
    }

    @Override
    protected int[] getInfoHoverStateMasks(String contentType) {
        SourceEditorViewerConfiguration config = this.getConfig(this.sections.getTypeByPartition(contentType));
        if (config != null) {
            return config.getInfoHoverStateMasks(contentType);
        }
        return null;
    }

    @Override
    protected ITextHover getInfoHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        SourceEditorViewerConfiguration config = this.getConfig(this.sections.getTypeByPartition(contentType));
        if (config != null) {
            return config.getTextHover(sourceViewer, contentType, stateMask);
        }
        return null;
    }

    @Override
    protected IInformationProvider getInformationProvider() {
        return new MultiContentSectionInformationProvider(this.sections){

            @Override
            protected EditorInformationProvider createHandler(String sectionType) {
                IInformationProvider provider;
                SourceEditorViewerConfiguration config = MultiContentSectionSourceViewerConfiguration.this.getConfig(sectionType);
                if (config != null && (provider = config.getInformationProvider()) instanceof EditorInformationProvider) {
                    return (EditorInformationProvider)provider;
                }
                return null;
            }
        };
    }

    @Override
    protected void collectHyperlinkDetectorTargets(Map<String, IAdaptable> targets, ISourceViewer sourceViewer) {
        this.primaryConfig.collectHyperlinkDetectorTargets(targets, sourceViewer);
        for (SourceEditorViewerConfiguration config : this.secondaryConfigs.values()) {
            config.collectHyperlinkDetectorTargets(targets, sourceViewer);
        }
    }

    private class LazyContentAssist
    extends ContentAssist {
        public IContentAssistProcessor getContentAssistProcessor(String contentType) {
            IContentAssistProcessor processor = super.getContentAssistProcessor(contentType);
            if (processor == null && MultiContentSectionSourceViewerConfiguration.this.checkInit(MultiContentSectionSourceViewerConfiguration.this.sections.getTypeByPartition(contentType))) {
                processor = super.getContentAssistProcessor(contentType);
            }
            return processor;
        }
    }

    private class LazyPresentationReconciler
    extends PresentationReconciler {
        private IDocument document;

        public void setDamager(IPresentationDamager damager, String contentType) {
            if (damager != null && this.document != null) {
                damager.setDocument(this.document);
            }
            super.setDamager(damager, contentType);
        }

        public void setRepairer(IPresentationRepairer repairer, String contentType) {
            if (repairer != null && this.document != null) {
                repairer.setDocument(this.document);
            }
            super.setRepairer(repairer, contentType);
        }

        public IPresentationDamager getDamager(String contentType) {
            IPresentationDamager damager = super.getDamager(contentType);
            if (damager == null && MultiContentSectionSourceViewerConfiguration.this.checkInit(MultiContentSectionSourceViewerConfiguration.this.sections.getTypeByPartition(contentType))) {
                damager = super.getDamager(contentType);
            }
            if (damager == null) {
                StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.statet.ltk.ui", "No presentation damager for contentType= " + contentType + "."));
            }
            return damager;
        }

        public IPresentationRepairer getRepairer(String contentType) {
            IPresentationRepairer repairer = super.getRepairer(contentType);
            if (repairer == null && MultiContentSectionSourceViewerConfiguration.this.checkInit(MultiContentSectionSourceViewerConfiguration.this.sections.getTypeByPartition(contentType))) {
                repairer = super.getRepairer(contentType);
            }
            if (repairer == null) {
                StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.statet.ltk.ui", "No presentation repairer for contentType= " + contentType + "."));
            }
            return repairer;
        }

        protected void setDocumentToDamagers(IDocument document) {
            this.document = document;
            super.setDocumentToDamagers(document);
        }
    }
}

