/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.io;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class UriUtils {
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    public static final String FILE_SCHEME = "file";
    public static final String JAR_SCHEME = "jar";
    public static final String JAR_SEPARATOR = "!/";

    public static final URI toUri(URL url) throws URISyntaxException {
        String s = url.toExternalForm();
        String scheme = url.getProtocol();
        String fragment = url.getRef();
        String spp = s.substring(scheme.length() + 1, fragment != null ? s.length() - fragment.length() - 1 : s.length());
        return new URI(scheme, spp, fragment);
    }

    private static boolean isScheme(@Nullable String scheme, String expectedScheme) {
        int n = expectedScheme.length();
        if (scheme == null || scheme.length() != n) {
            return false;
        }
        int index = 0;
        while (index < n) {
            char cExpected;
            char c = scheme.charAt(index);
            if (c != (cExpected = expectedScheme.charAt(index)) && Character.toLowerCase(c) != cExpected) {
                return false;
            }
            ++index;
        }
        return true;
    }

    private static boolean isSchemeUrl(String urlString, String expectedScheme) {
        int n = expectedScheme.length();
        if (urlString.length() <= n || urlString.charAt(n) != ':') {
            return false;
        }
        int index = 0;
        while (index < n) {
            char cExpected;
            char c = urlString.charAt(index);
            if (c != (cExpected = expectedScheme.charAt(index)) && Character.toLowerCase(c) != cExpected) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static final boolean isFileUrl(URI url) {
        return UriUtils.isScheme(url.getScheme(), FILE_SCHEME);
    }

    public static final boolean isFileUrl(String urlString) {
        return UriUtils.isSchemeUrl(urlString, FILE_SCHEME);
    }

    public static final boolean isJarUrl(URI url) {
        return UriUtils.isScheme(url.getScheme(), JAR_SCHEME);
    }

    private static URI assertJarUrlArgument(URI url) {
        if (!UriUtils.isJarUrl(url)) {
            throw new IllegalArgumentException("no JAR url");
        }
        return url;
    }

    public static final boolean isJarUrl(String urlString) {
        return UriUtils.isSchemeUrl(urlString, JAR_SCHEME);
    }

    public static final URI getJarFileUrl(URI url) throws URISyntaxException {
        UriUtils.assertJarUrlArgument(url);
        String ssp = url.getSchemeSpecificPart();
        int containerSchemeIdx = ssp.indexOf(58);
        if (containerSchemeIdx <= 0) {
            throw new URISyntaxException(url.toString(), "missing container scheme");
        }
        int jarSepIdx = ssp.lastIndexOf(JAR_SEPARATOR);
        if (jarSepIdx < containerSchemeIdx) {
            throw new URISyntaxException(url.toString(), "missing JAR separator");
        }
        return ssp.lastIndexOf(JAR_SEPARATOR, jarSepIdx - 1) == -1 ? new URI(ssp.substring(0, containerSchemeIdx), ssp.substring(containerSchemeIdx + 1, jarSepIdx), url.getFragment()) : new URI(url.getScheme(), ssp.substring(0, jarSepIdx), url.getFragment());
    }

    public static final String getJarEntryPath(URI url) throws URISyntaxException {
        UriUtils.assertJarUrlArgument(url);
        String ssp = url.getSchemeSpecificPart();
        int containerSchemeIdx = ssp.indexOf(58);
        if (containerSchemeIdx <= 0) {
            throw new URISyntaxException(url.toString(), "missing container scheme");
        }
        int jarSepIdx = ssp.lastIndexOf(JAR_SEPARATOR);
        if (jarSepIdx < containerSchemeIdx) {
            throw new URISyntaxException(url.toString(), "missing JAR separator");
        }
        return ssp.substring(jarSepIdx + 2, ssp.length());
    }

    public static final URI toJarUrl(String jarFileUrlString) throws URISyntaxException {
        return new URI(UriUtils.toJarUrlString(jarFileUrlString));
    }

    public static final String toJarUrlString(String jarFileUrlString) throws URISyntaxException {
        StringBuilder sb = new StringBuilder(jarFileUrlString.length() + 6);
        if (!UriUtils.isSchemeUrl(jarFileUrlString, JAR_SCHEME)) {
            sb.append("jar:");
        }
        sb.append(jarFileUrlString);
        sb.append(JAR_SEPARATOR);
        return sb.toString();
    }

    private UriUtils() {
    }
}

