/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.datafilterview;

import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.ui.components.WaScale;
import org.eclipse.statet.ecommons.ui.content.IntValue2Double2TextBinding;
import org.eclipse.statet.ecommons.ui.content.IntValue2TextBinding;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.r.ui.datafilter.IntervalVariableFilter;
import org.eclipse.statet.internal.r.ui.datafilterview.FilterClient;
import org.eclipse.statet.internal.r.ui.datafilterview.Int2TextConverter;
import org.eclipse.statet.internal.r.ui.datafilterview.Messages;
import org.eclipse.statet.internal.r.ui.datafilterview.Num2TextConverter;
import org.eclipse.statet.internal.r.ui.datafilterview.Text2IntConverter;
import org.eclipse.statet.internal.r.ui.datafilterview.Text2NumConverter;
import org.eclipse.statet.internal.r.ui.datafilterview.VariableComposite;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public class IntervalClient
extends FilterClient {
    private final IntervalVariableFilter filter;
    private WaScale scaleControl = (WaScale)ObjectUtils.nonNullLateInit();
    private Text lowerBoundControl = (Text)ObjectUtils.nonNullLateInit();
    private Text upperBoundControl = (Text)ObjectUtils.nonNullLateInit();
    private Object lowerUpperGroup = ObjectUtils.nonNullLateInit();
    private Button NAControl = (Button)ObjectUtils.nonNullLateInit();

    public IntervalClient(VariableComposite parent, IntervalVariableFilter filter) {
        super(parent);
        this.filter = filter;
        filter.setListener(this);
        this.init(5);
    }

    @Override
    public IntervalVariableFilter getFilter() {
        return this.filter;
    }

    @Override
    protected void addWidgets() {
        this.scaleControl = new WaScale((Composite)this, 256);
        this.scaleControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 5, 1));
        this.lowerBoundControl = new Text((Composite)this, 2048);
        this.lowerBoundControl.setLayoutData((Object)LayoutUtils.hintWidth((GridData)new GridData(4, 0x1000000, true, false), (Text)this.lowerBoundControl, (int)10));
        this.lowerBoundControl.setToolTipText(Messages.Interval_LowerBound_tooltip);
        LayoutUtils.addGDDummy((Composite)this, (boolean)true);
        this.NAControl = new Button((Composite)this, 32);
        this.NAControl.setText("NA");
        this.NAControl.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.dialogfont"));
        this.NAControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        LayoutUtils.addGDDummy((Composite)this, (boolean)true);
        this.upperBoundControl = new Text((Composite)this, 2048);
        this.upperBoundControl.setLayoutData((Object)LayoutUtils.hintWidth((GridData)new GridData(4, 0x1000000, true, false), (Text)this.lowerBoundControl, (int)10));
        this.upperBoundControl.setToolTipText(Messages.Interval_UpperBound_tooltip);
    }

    @Override
    protected void initActions(IServiceLocator serviceLocator) {
    }

    @Override
    protected void addBindings(DataBindingSupport db) {
        if (this.filter.getColumn().getDataStore().getStoreType() == 3) {
            Text2NumConverter text2value = new Text2NumConverter();
            Num2TextConverter value2text = new Num2TextConverter();
            IntValue2Double2TextBinding.LowerUpperGroup group = new IntValue2Double2TextBinding.LowerUpperGroup(this.scaleControl, this.lowerBoundControl, this.upperBoundControl, db.getRealm(), (IConverter)value2text, (IConverter)text2value);
            db.getContext().bindValue((IObservableValue)group.getLower(), this.filter.getSelectedLowerValue());
            db.getContext().bindValue((IObservableValue)group.getUpper(), this.filter.getSelectedUpperValue());
            this.lowerUpperGroup = group;
        } else {
            Text2IntConverter text2value = new Text2IntConverter();
            Int2TextConverter value2text = new Int2TextConverter();
            IntValue2TextBinding.LowerUpperGroup group = new IntValue2TextBinding.LowerUpperGroup(this.scaleControl, this.lowerBoundControl, this.upperBoundControl, db.getRealm(), (IConverter)value2text, (IConverter)text2value);
            db.getContext().bindValue((IObservableValue)group.getLower(), this.filter.getSelectedLowerValue());
            db.getContext().bindValue((IObservableValue)group.getUpper(), this.filter.getSelectedUpperValue());
            this.lowerUpperGroup = group;
        }
        db.getContext().bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.NAControl), this.filter.getSelectedNA());
    }

    @Override
    protected void updateInput() {
        RStore<? extends Number> minMaxData = this.filter.getMinMaxData();
        if (minMaxData == null) {
            this.setEnabled(false, false);
            return;
        }
        if (this.lowerUpperGroup instanceof IntValue2Double2TextBinding.LowerUpperGroup) {
            double max;
            double min = minMaxData.getNum(0);
            this.setEnabled(min != (max = minMaxData.getNum(1)), minMaxData.getLogi(2));
            ((IntValue2Double2TextBinding.LowerUpperGroup)this.lowerUpperGroup).setMinMax(min, max);
        } else {
            int max;
            int min = minMaxData.getInt(0);
            this.setEnabled(min != (max = minMaxData.getInt(1)), minMaxData.getLogi(2));
            ((IntValue2TextBinding.LowerUpperGroup)this.lowerUpperGroup).setMinMax(min, max);
        }
    }

    public void setEnabled(boolean scale, boolean na) {
        if (this.scaleControl.getEnabled() != scale) {
            this.scaleControl.setEnabled(scale);
            this.lowerBoundControl.setEnabled(scale);
            this.upperBoundControl.setEnabled(scale);
        }
        if (this.NAControl.getEnabled() != na) {
            this.NAControl.setEnabled(na);
            this.NAControl.setVisible(na);
        }
    }
}

