/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.datafilterview;

import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.databinding.UpdateSetStrategy;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.ui.actions.ControlServicesUtil;
import org.eclipse.statet.ecommons.ui.actions.HandlerCollection;
import org.eclipse.statet.ecommons.ui.actions.HandlerContributionItem;
import org.eclipse.statet.ecommons.ui.util.AutoCheckController;
import org.eclipse.statet.internal.r.ui.datafilter.LevelVariableFilter;
import org.eclipse.statet.internal.r.ui.datafilterview.ColumnLabelProvider;
import org.eclipse.statet.internal.r.ui.datafilterview.FilterClient;
import org.eclipse.statet.internal.r.ui.datafilterview.RStore2UIConverter;
import org.eclipse.statet.internal.r.ui.datafilterview.RStoreContentProvider;
import org.eclipse.statet.internal.r.ui.datafilterview.UI2RStoreConverter;
import org.eclipse.statet.internal.r.ui.datafilterview.VariableComposite;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public class LevelClient
extends FilterClient {
    private final LevelVariableFilter filter;
    private RStore<?> availableValues;
    private final IObservableSet<Object> selectedValues;
    private CheckboxTableViewer valueListViewer = (CheckboxTableViewer)ObjectUtils.nonNullLateInit();
    private final HandlerCollection valueListHandlers = new HandlerCollection();
    private MenuManager valueListMenuManager = (MenuManager)ObjectUtils.nonNullLateInit();

    public LevelClient(VariableComposite parent, LevelVariableFilter filter) {
        super(parent);
        this.filter = filter;
        filter.setListener(this);
        this.availableValues = filter.getAvailableValues();
        this.selectedValues = filter.getSelectedValues();
        this.init(1);
    }

    @Override
    public LevelVariableFilter getFilter() {
        return this.filter;
    }

    @Override
    protected void addWidgets() {
        this.valueListViewer = CheckboxTableViewer.newCheckList((Composite)this, (int)8454146);
        this.valueListViewer.setContentProvider((IContentProvider)new RStoreContentProvider());
        this.valueListViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(this.filter.getColumn()));
    }

    @Override
    protected void initActions(IServiceLocator serviceLocator) {
        ControlServicesUtil servicesUtil = new ControlServicesUtil(serviceLocator, String.valueOf(this.getClass().getName()) + "/ValueList#" + this.hashCode(), (Control)this);
        servicesUtil.addControl((Control)this.valueListViewer.getTable());
        AutoCheckController autoCheckController = new AutoCheckController(this.valueListViewer, this.filter.getSelectedValues());
        IHandler2 handler = autoCheckController.createSelectAllHandler();
        this.valueListHandlers.add("org.eclipse.ui.edit.selectAll", handler);
        servicesUtil.activateHandler("org.eclipse.ui.edit.selectAll", (IHandler)handler);
        this.valueListMenuManager = new MenuManager();
        this.valueListMenuManager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, "org.eclipse.ui.edit.selectAll", 8), (IHandler2)ObjectUtils.nonNullAssert((Object)this.valueListHandlers.get("org.eclipse.ui.edit.selectAll"))));
        this.valueListViewer.getTable().setMenu(this.valueListMenuManager.createContextMenu(this.valueListViewer.getControl()));
    }

    @Override
    protected void addBindings(DataBindingSupport db) {
        db.getContext().bindSet(ViewerProperties.checkedElements(Object.class).observe((Object)this.valueListViewer), this.selectedValues, new UpdateSetStrategy().setConverter(new UI2RStoreConverter()), new UpdateSetStrategy().setConverter(new RStore2UIConverter()));
    }

    @Override
    protected void updateInput() {
        this.availableValues = this.filter.getAvailableValues();
        this.valueListViewer.setInput(this.availableValues);
        this.valueListViewer.setCheckedElements(this.selectedValues.toArray());
        this.checkLayout();
    }

    @Override
    protected boolean updateLayout() {
        return this.updateLayout((TableViewer)this.valueListViewer, (int)this.availableValues.getLength());
    }

    @Override
    protected void onDispose() {
        if (this.valueListMenuManager != null) {
            this.valueListMenuManager.dispose();
            this.valueListMenuManager = null;
        }
        super.onDispose();
    }
}

