/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.layer.event;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.event.IVisualChangeEvent;

public class CellVisualChangeEvent
implements IVisualChangeEvent {
    protected ILayer layer;
    protected long columnPosition;
    protected long rowPosition;

    public CellVisualChangeEvent(ILayer layer, long columnPosition, long rowPosition) {
        this.layer = layer;
        this.columnPosition = columnPosition;
        this.rowPosition = rowPosition;
    }

    protected CellVisualChangeEvent(CellVisualChangeEvent event) {
        this.layer = event.layer;
        this.columnPosition = event.columnPosition;
        this.rowPosition = event.rowPosition;
    }

    @Override
    public ILayer getLayer() {
        return this.layer;
    }

    public long getColumnPosition() {
        return this.columnPosition;
    }

    public long getRowPosition() {
        return this.rowPosition;
    }

    @Override
    public boolean convertToLocal(ILayer localLayer) {
        this.columnPosition = localLayer.getDim(Orientation.HORIZONTAL).underlyingToLocalPosition(this.layer.getDim(Orientation.HORIZONTAL), this.columnPosition);
        this.rowPosition = localLayer.getDim(Orientation.VERTICAL).underlyingToLocalPosition(this.layer.getDim(Orientation.VERTICAL), this.rowPosition);
        this.layer = localLayer;
        return this.columnPosition >= 0L && this.rowPosition >= 0L && this.columnPosition < this.layer.getColumnCount() && this.rowPosition < this.layer.getRowCount();
    }

    @Override
    public Collection<LRectangle> getChangedPositionRectangles() {
        return Arrays.asList(new LRectangle(this.columnPosition, this.rowPosition, 1L, 1L));
    }

    @Override
    public CellVisualChangeEvent cloneEvent() {
        return new CellVisualChangeEvent(this);
    }
}

