/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.templates;

import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.statet.ecommons.text.TextUtil;
import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.jcommons.util.StringUtils;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.templates.IWorkbenchTemplateContext;
import org.eclipse.statet.ltk.ui.templates.TemplateUtils;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

@NonNullByDefault
public class SourceEditorTemplateContext
extends DocumentTemplateContext
implements IWorkbenchTemplateContext {
    public static final int FORMAT = 16;
    public static final int FORMAT_START = 32;
    protected static final String SELECTION_VAR_NAME = "selection";
    protected static final String INDENTATION_VAR_NAME = "indentation";
    private final SourceEditor editor;
    private final int flags;

    public SourceEditorTemplateContext(TemplateContextType type, IDocument document, TextRegion region, SourceEditor editor, int flags) {
        super(type, document, region.getStartOffset(), region.getLength());
        this.editor = editor;
        this.flags = flags;
    }

    @Override
    public SourceEditor getEditor() {
        return this.editor;
    }

    @Override
    public @Nullable SourceUnit getSourceUnit() {
        return this.editor.getSourceUnit();
    }

    public int getFlags() {
        return this.flags;
    }

    @Override
    public @Nullable String evaluateInfo(Template template) throws BadLocationException, TemplateException {
        TemplateBuffer buffer = super.evaluate(template);
        if (buffer != null) {
            return buffer.getString();
        }
        return null;
    }

    public @Nullable TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        if (!this.canEvaluate(template)) {
            return null;
        }
        String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocument());
        TemplateTranslator translator = new TemplateTranslator();
        String pattern = template.getPattern();
        Matcher matcher = TextUtil.LINE_DELIMITER_PATTERN.matcher(pattern);
        if (matcher.find()) {
            pattern = matcher.replaceAll(lineDelimiter);
        }
        TemplateBuffer buffer = translator.translate(pattern);
        this.getContextType().resolve(buffer, (TemplateContext)this);
        this.format(buffer);
        String selection = this.getVariable(SELECTION_VAR_NAME);
        if (selection != null && StringUtils.containsAny((String)selection, (ImCollection)ImCollections.newList((Object[])this.getDocument().getLegalLineDelimiters()))) {
            buffer.setContent(String.valueOf(buffer.getString()) + lineDelimiter, buffer.getVariables());
        }
        return buffer;
    }

    private void format(TemplateBuffer buffer) throws BadLocationException {
        TemplateVariable[] variables = buffer.getVariables();
        List<TextEdit> positions = TemplateUtils.variablesToPositions(variables);
        IDocument baseDoc = this.getDocument();
        Document templateDoc = new Document(buffer.getString());
        MultiTextEdit root = new MultiTextEdit(0, templateDoc.getLength());
        root.addChildren(positions.toArray(new TextEdit[positions.size()]));
        this.format(root, (IDocument)templateDoc, variables, baseDoc);
        root.apply((IDocument)templateDoc, 2);
        TemplateUtils.positionsToVariables(positions, variables);
        buffer.setContent(templateDoc.get(), variables);
    }

    protected void format(MultiTextEdit root, IDocument templateDoc, TemplateVariable[] variables, IDocument baseDoc) throws BadLocationException {
        this.indent(root, templateDoc, variables, baseDoc);
        if ((this.getFlags() & 0x20) != 0 && this.getVariable(INDENTATION_VAR_NAME) == null && this.getStart() > 0 && !Character.isWhitespace(baseDoc.getChar(this.getStart() - 1)) && templateDoc.getLength() > 0 && !Character.isWhitespace(templateDoc.getChar(0))) {
            root.addChild((TextEdit)new InsertEdit(0, " "));
        }
    }

    protected void indent(MultiTextEdit root, IDocument templateDoc, TemplateVariable[] variables, IDocument baseDoc) throws BadLocationException {
        InsertEdit edit;
        String indentation = this.getVariable(INDENTATION_VAR_NAME);
        int line = 0;
        int offset = templateDoc.getLineOffset(line);
        if (indentation != null) {
            edit = new InsertEdit(offset, indentation);
            root.addChild((TextEdit)edit);
        } else {
            indentation = TemplateUtils.searchIndentation(baseDoc, this.getStart());
        }
        while (++line < templateDoc.getNumberOfLines()) {
            offset = templateDoc.getLineOffset(line);
            edit = new InsertEdit(offset, indentation);
            root.addChild((TextEdit)edit);
        }
    }
}

