/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core;

import java.util.List;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.ltk.model.core.element.SourceElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.RFrame;
import org.eclipse.statet.r.core.model.RLangElement;

@NonNullByDefault
public class FilteredFrame<TModelChild extends RLangElement>
implements RFrame<TModelChild>,
LtkModelElementFilter<LtkModelElement> {
    private final RFrame<TModelChild> frame;
    private final SourceUnit exclude;

    public FilteredFrame(RFrame<TModelChild> frame, SourceUnit exclude) {
        this.frame = frame;
        this.exclude = exclude;
    }

    @Override
    public @Nullable String getFrameId() {
        return this.frame.getFrameId();
    }

    @Override
    public int getFrameType() {
        return this.frame.getFrameType();
    }

    @Override
    public RElementName getElementName() {
        return this.frame.getElementName();
    }

    @Override
    public boolean hasModelChildren(@Nullable LtkModelElementFilter<? super TModelChild> filter) {
        return this.frame.hasModelChildren(this.exclude != null ? this : null);
    }

    @Override
    public List<? extends TModelChild> getModelChildren(@Nullable LtkModelElementFilter<? super TModelChild> filter) {
        return this.frame.getModelChildren(this.exclude != null ? this : null);
    }

    @Override
    public List<? extends TModelChild> getModelElements() {
        return this.frame.getModelElements();
    }

    @Override
    public List<? extends RFrame> getPotentialParents() {
        return this.frame.getPotentialParents();
    }

    public boolean include(LtkModelElement element) {
        SourceUnit su;
        SourceUnit sourceUnit = su = element instanceof SourceElement ? ((SourceElement)element).getSourceUnit() : null;
        return su == null || !this.exclude.getId().equals(su.getId());
    }

    public String toString() {
        ObjectUtils.ToStringBuilder builder = new ObjectUtils.ToStringBuilder("FilteredFrame", this.getClass());
        builder.addProp("frame", this.frame);
        builder.addProp("exclude", (Object)this.exclude);
        return builder.build();
    }
}

