/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.layer;

import java.util.Properties;
import org.eclipse.statet.ecommons.waltable.command.ILayerCommand;
import org.eclipse.statet.ecommons.waltable.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.coordinate.PositionOutOfBoundsException;
import org.eclipse.statet.ecommons.waltable.layer.AbstractLayer;
import org.eclipse.statet.ecommons.waltable.layer.CompositeLayerDim;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.layer.cell.AggregrateConfigLabelAccumulator;
import org.eclipse.statet.ecommons.waltable.layer.cell.ForwardLayerCell;
import org.eclipse.statet.ecommons.waltable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCellDim;
import org.eclipse.statet.ecommons.waltable.layer.cell.LayerCellDim;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.painter.layer.ILayerPainter;
import org.eclipse.statet.ecommons.waltable.ui.IClientAreaProvider;
import org.eclipse.statet.ecommons.waltable.ui.binding.UiBindingRegistry;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class CompositeLayer
extends AbstractLayer {
    protected final int layoutXCount;
    protected final int layoutYCount;
    private final Child[][] childLayout;

    public CompositeLayer(int layoutXCount, int layoutYCount) {
        this.layoutXCount = layoutXCount;
        this.layoutYCount = layoutYCount;
        this.childLayout = new Child[layoutXCount][layoutYCount];
        this.initDims();
    }

    @Override
    protected void initDims() {
        if (this.childLayout == null) {
            return;
        }
        Orientation[] orientationArray = Orientation.values();
        int n = orientationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Orientation orientation = orientationArray[n2];
            this.setDim(this.ignoreRef(orientation) ? new CompositeLayerDim.IgnoreRef(this, orientation) : new CompositeLayerDim(this, orientation));
            ++n2;
        }
    }

    protected boolean ignoreRef(Orientation orientation) {
        return false;
    }

    final CompositeLayerDim get(Orientation orientation) {
        return (CompositeLayerDim)this.getDim(orientation);
    }

    @Override
    protected ILayerPainter createPainter() {
        return new CompositeLayerPainter();
    }

    @Override
    public void dispose() {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            int layoutY = 0;
            while (layoutY < this.layoutYCount) {
                Child child = this.childLayout[layoutX][layoutY];
                if (child != null) {
                    child.layer.dispose();
                }
                ++layoutY;
            }
            ++layoutX;
        }
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            int layoutY = 0;
            while (layoutY < this.layoutYCount) {
                Child child = this.childLayout[layoutX][layoutY];
                if (child != null) {
                    child.layer.saveState(String.valueOf(prefix) + "." + child.label, properties);
                }
                ++layoutY;
            }
            ++layoutX;
        }
        super.saveState(prefix, properties);
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            int layoutY = 0;
            while (layoutY < this.layoutYCount) {
                Child child = this.childLayout[layoutX][layoutY];
                if (child != null) {
                    child.layer.loadState(String.valueOf(prefix) + "." + child.label, properties);
                }
                ++layoutY;
            }
            ++layoutX;
        }
        super.loadState(prefix, properties);
    }

    @Override
    public void configure(ConfigRegistry configRegistry, UiBindingRegistry uiBindingRegistry) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            int layoutY = 0;
            while (layoutY < this.layoutYCount) {
                this.childLayout[layoutX][layoutY].layer.configure(configRegistry, uiBindingRegistry);
                ++layoutY;
            }
            ++layoutX;
        }
        super.configure(configRegistry, uiBindingRegistry);
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (super.doCommand(command)) {
            return true;
        }
        return this.doCommandOnChildLayers(command);
    }

    protected boolean doCommandOnChildLayers(ILayerCommand command) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            int layoutY = 0;
            while (layoutY < this.layoutYCount) {
                if (this.childLayout[layoutX][layoutY].layer.doCommand(command)) {
                    return true;
                }
                ++layoutY;
            }
            ++layoutX;
        }
        return false;
    }

    @Override
    public ILayerCell getCellByPosition(long columnPosition, long rowPosition) {
        final Child child = this.getChildByPosition(columnPosition, rowPosition);
        if (child == null) {
            throw new PositionOutOfBoundsException(String.valueOf(columnPosition) + ", " + rowPosition);
        }
        final long childColumnPosition = columnPosition - this.get(Orientation.HORIZONTAL).getLayoutPosition(child.layoutX);
        final long childRowPosition = rowPosition - this.get(Orientation.VERTICAL).getLayoutPosition(child.layoutY);
        ILayerCell underlyingCell = child.layer.getCellByPosition(childColumnPosition, childRowPosition);
        ILayerCellDim hDim = this.transformCellDim(underlyingCell.getDim(Orientation.HORIZONTAL), columnPosition);
        ILayerCellDim vDim = this.transformCellDim(underlyingCell.getDim(Orientation.VERTICAL), rowPosition);
        return new ForwardLayerCell(this, hDim, vDim, underlyingCell){

            @Override
            public LabelStack getConfigLabels() {
                LabelStack configLabels = super.getConfigLabels();
                if (child.configLabelAccumulator != null) {
                    child.configLabelAccumulator.accumulateConfigLabels(configLabels, childColumnPosition, childRowPosition);
                }
                configLabels.addLabel(child.label);
                return configLabels;
            }
        };
    }

    protected ILayerCellDim transformCellDim(ILayerCellDim underlyingDim, long position) {
        long originPosition = underlyingDim.getPosition() == underlyingDim.getOriginPosition() ? position : this.get(underlyingDim.getOrientation()).underlyingToLocalPosition(position, underlyingDim.getOriginPosition());
        return new LayerCellDim(underlyingDim.getOrientation(), underlyingDim.getId(), position, originPosition, underlyingDim.getPositionSpan());
    }

    public void setChildLayer(String label, ILayer childLayer, int layoutX, int layoutY) {
        if (childLayer == null) {
            throw new IllegalArgumentException("Cannot set null child layer");
        }
        final Child child = new Child(layoutX, layoutY, label, childLayer);
        childLayer.addLayerListener(this);
        this.childLayout[layoutX][layoutY] = child;
        this.get(Orientation.HORIZONTAL).updateChild(layoutX, layoutY, childLayer);
        this.get(Orientation.VERTICAL).updateChild(layoutY, layoutX, childLayer);
        childLayer.setClientAreaProvider(new IClientAreaProvider(){

            @Override
            public LRectangle getClientArea() {
                return CompositeLayer.this.getChildClientArea(child);
            }
        });
    }

    public void addConfigLabelAccumulatorForRegion(String regionLabel, IConfigLabelAccumulator configLabelAccumulator) {
        Child child = this.getChildByLabel(regionLabel);
        if (child.configLabelAccumulator == null) {
            child.configLabelAccumulator = configLabelAccumulator;
        } else {
            AggregrateConfigLabelAccumulator aggregateAccumulator;
            if (child.configLabelAccumulator instanceof AggregrateConfigLabelAccumulator) {
                aggregateAccumulator = (AggregrateConfigLabelAccumulator)child.configLabelAccumulator;
            } else {
                aggregateAccumulator = new AggregrateConfigLabelAccumulator();
                aggregateAccumulator.add(child.configLabelAccumulator);
                child.configLabelAccumulator = aggregateAccumulator;
            }
            aggregateAccumulator.add(configLabelAccumulator);
        }
    }

    private LRectangle getChildClientArea(Child child) {
        LRectangle compositeClientArea = this.getClientAreaProvider().getClientArea();
        LRectangle childClientArea = new LRectangle(compositeClientArea.x + this.get(Orientation.HORIZONTAL).getLayoutStart(child.layoutX), compositeClientArea.y + this.get(Orientation.VERTICAL).getLayoutStart(child.layoutY), child.layer.getDim(Orientation.HORIZONTAL).getPreferredSize(), child.layer.getDim(Orientation.VERTICAL).getPreferredSize());
        LRectangle intersection = compositeClientArea.intersection(childClientArea);
        return intersection;
    }

    public ILayer getChildLayerByLayoutCoordinate(int layoutX, int layoutY) {
        if (layoutX < 0 || layoutX >= this.layoutXCount || layoutY < 0 || layoutY >= this.layoutYCount) {
            return null;
        }
        return this.childLayout[layoutX][layoutY].layer;
    }

    @Override
    public LabelStack getRegionLabelsByXY(long x, long y) {
        Child child = this.getChildByPixelXY(x, y);
        if (child == null) {
            return null;
        }
        long childX = x - this.get(Orientation.HORIZONTAL).getLayoutStart(child.layoutX);
        long childY = y - this.get(Orientation.VERTICAL).getLayoutStart(child.layoutY);
        LabelStack regionLabels = child.layer.getRegionLabelsByXY(childX, childY);
        regionLabels.addLabel(child.label);
        return regionLabels;
    }

    @Override
    public ILayer getUnderlyingLayerByPosition(long columnPosition, long rowPosition) {
        Child child = this.getChildByPosition(columnPosition, rowPosition);
        return child != null ? child.layer : null;
    }

    protected final Child getChildByLabel(String label) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            int layoutY = 0;
            while (layoutY < this.layoutYCount) {
                if (label.equals(this.childLayout[layoutX][layoutY].label)) {
                    return this.childLayout[layoutX][layoutY];
                }
                ++layoutY;
            }
            ++layoutX;
        }
        return null;
    }

    protected final Child getChildByLayer(ILayer childLayer) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            int layoutY = 0;
            while (layoutY < this.layoutYCount) {
                if (this.childLayout[layoutX][layoutY].layer == childLayer) {
                    return this.childLayout[layoutX][layoutY];
                }
                ++layoutY;
            }
            ++layoutX;
        }
        return null;
    }

    protected final Child getChildByPixelXY(long x, long y) {
        int layoutX = this.get(Orientation.HORIZONTAL).getLayoutByPixel(x);
        if (layoutX < 0) {
            return null;
        }
        int layoutY = this.get(Orientation.VERTICAL).getLayoutByPixel(y);
        if (layoutY < 0) {
            return null;
        }
        return this.childLayout[layoutX][layoutY];
    }

    protected final Child getChildByPosition(long compositeColumnPosition, long compositeRowPosition) {
        int layoutX = this.get(Orientation.HORIZONTAL).getLayoutByPosition(compositeColumnPosition);
        if (layoutX < 0) {
            return null;
        }
        int layoutY = this.get(Orientation.VERTICAL).getLayoutByPosition(compositeRowPosition);
        if (layoutY < 0) {
            return null;
        }
        return this.childLayout[layoutX][layoutY];
    }

    protected static final class Child {
        public final int layoutX;
        public final int layoutY;
        public final String label;
        public final ILayer layer;
        private IConfigLabelAccumulator configLabelAccumulator;

        private Child(int x, int y, String label, ILayer layer) {
            this.layoutX = x;
            this.layoutY = y;
            this.label = label;
            this.layer = layer;
        }
    }

    protected class CompositeLayerPainter
    implements ILayerPainter {
        protected CompositeLayerPainter() {
        }

        @Override
        public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle pixelRectangle, IConfigRegistry configuration) {
            int x = xOffset;
            int layoutX = 0;
            while (layoutX < CompositeLayer.this.layoutXCount) {
                int y = yOffset;
                int width = GraphicsUtils.safe(CompositeLayer.this.childLayout[layoutX][0].layer.getWidth());
                int layoutY = 0;
                while (layoutY < CompositeLayer.this.layoutYCount) {
                    Child child = CompositeLayer.this.childLayout[layoutX][layoutY];
                    Rectangle childRectangle = new Rectangle(x, y, width, GraphicsUtils.safe(child.layer.getHeight()));
                    Rectangle childPaintRectangle = pixelRectangle.intersection(childRectangle);
                    if (!childPaintRectangle.isEmpty()) {
                        Rectangle originalClipping = gc.getClipping();
                        gc.setClipping(childPaintRectangle);
                        child.layer.getLayerPainter().paintLayer(natLayer, gc, x, y, childPaintRectangle, configuration);
                        gc.setClipping(originalClipping);
                    }
                    y += childRectangle.height;
                    ++layoutY;
                }
                x += width;
                ++layoutX;
            }
        }

        @Override
        public LRectangle adjustCellBounds(long columnPosition, long rowPosition, LRectangle cellBounds) {
            Child child = CompositeLayer.this.getChildByPosition(columnPosition, rowPosition);
            long widthOffset = CompositeLayer.this.get(Orientation.HORIZONTAL).getLayoutStart(child.layoutX);
            long heightOffset = CompositeLayer.this.get(Orientation.VERTICAL).getLayoutStart(child.layoutY);
            cellBounds.x -= widthOffset;
            cellBounds.y -= heightOffset;
            ILayerPainter childLayerPainter = child.layer.getLayerPainter();
            long childColumnPosition = columnPosition - CompositeLayer.this.get(Orientation.HORIZONTAL).getLayoutPosition(child.layoutX);
            long childRowPosition = rowPosition - CompositeLayer.this.get(Orientation.VERTICAL).getLayoutPosition(child.layoutY);
            LRectangle adjustedChildCellBounds = childLayerPainter.adjustCellBounds(childColumnPosition, childRowPosition, cellBounds);
            adjustedChildCellBounds.x += widthOffset;
            adjustedChildCellBounds.y += heightOffset;
            return adjustedChildCellBounds;
        }
    }
}

