/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.dbg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RJIOExternalizable;
import org.eclipse.statet.rj.server.dbg.SrcfileData;
import org.eclipse.statet.rj.server.dbg.TracepointPosition;

@NonNullByDefault
public class ElementTracepoints
implements RJIOExternalizable {
    private final SrcfileData fileInfo;
    private final String elementId;
    private final int @Nullable [] elementSrcref;
    private final List<TracepointPosition> positions;

    public ElementTracepoints(SrcfileData fileInfo, String elementId, int @Nullable [] elementSrcref, List<TracepointPosition> positions) {
        if (fileInfo == null) {
            throw new NullPointerException("fileInfo");
        }
        if (elementId == null) {
            throw new NullPointerException("elementId");
        }
        this.fileInfo = fileInfo;
        this.elementId = elementId;
        this.elementSrcref = elementSrcref;
        this.positions = positions;
    }

    public ElementTracepoints(SrcfileData fileInfo, String elementId, int @Nullable [] elementSrcref) {
        this(fileInfo, elementId, elementSrcref, new ArrayList<TracepointPosition>(4));
    }

    public ElementTracepoints(RJIO io) throws IOException {
        this.fileInfo = new SrcfileData(io);
        this.elementId = io.readString();
        this.elementSrcref = io.readIntArray();
        int l = io.readInt();
        this.positions = new ArrayList<TracepointPosition>(l);
        int i = 0;
        while (i < l) {
            this.positions.add(new TracepointPosition(io));
            ++i;
        }
    }

    public void writeExternal(RJIO io) throws IOException {
        this.fileInfo.writeExternal(io);
        io.writeString(this.elementId);
        io.writeIntArray(this.elementSrcref, this.elementSrcref != null ? 6 : -1);
        int l = this.positions.size();
        io.writeInt(l);
        int i = 0;
        while (i < l) {
            this.positions.get(i).writeExternal(io);
            ++i;
        }
    }

    public SrcfileData getSrcfile() {
        return this.fileInfo;
    }

    public String getElementId() {
        return this.elementId;
    }

    public int @Nullable [] getElementSrcref() {
        return this.elementSrcref;
    }

    public List<? extends TracepointPosition> getPositions() {
        return this.positions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ElementTracepoints");
        sb.append(" for ").append(this.elementId);
        sb.append("\n").append("list (count= ").append(this.positions.size()).append("):");
        int i = 0;
        while (i < this.positions.size()) {
            sb.append("\n").append(this.positions.get(i).toString());
            ++i;
        }
        return sb.toString();
    }
}

