/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.command;

import org.eclipse.statet.ecommons.waltable.command.LayerCommandUtil;
import org.eclipse.statet.ecommons.waltable.coordinate.PositionCoordinate;
import org.eclipse.statet.ecommons.waltable.core.command.LayerCommand;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;

public abstract class AbstractPositionCommand
implements LayerCommand {
    private PositionCoordinate positionCoordinate;

    protected AbstractPositionCommand(Layer layer, long columnPosition, long rowPosition) {
        this.positionCoordinate = new PositionCoordinate(layer, columnPosition, rowPosition);
    }

    protected AbstractPositionCommand(AbstractPositionCommand command) {
        this.positionCoordinate = command.positionCoordinate;
    }

    public long getColumnPosition() {
        return this.positionCoordinate.getColumnPosition();
    }

    public long getRowPosition() {
        return this.positionCoordinate.getRowPosition();
    }

    @Override
    public boolean convertToTargetLayer(Layer targetLayer) {
        PositionCoordinate targetPositionCoordinate = LayerCommandUtil.convertPositionToTargetContext(this.positionCoordinate, targetLayer);
        if (targetPositionCoordinate != null) {
            this.positionCoordinate = targetPositionCoordinate;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " columnPosition=" + this.positionCoordinate.getColumnPosition() + ", rowPosition=" + this.positionCoordinate.getRowPosition();
    }
}

