/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.renv;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.runtime.core.util.StatusUtils;
import org.eclipse.statet.internal.r.core.Messages;
import org.eclipse.statet.internal.r.core.RCorePlugin;
import org.eclipse.statet.internal.r.core.renv.ActualREnv;
import org.eclipse.statet.internal.r.core.renv.REnvManagerLibGroup;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.lang.SystemUtils;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.r.core.RCorePreferenceNodes;
import org.eclipse.statet.r.core.renv.IREnvConfiguration;
import org.eclipse.statet.rhelp.core.REnvHelpConfiguration;
import org.eclipse.statet.rj.renv.core.BasicREnvConfiguration;
import org.eclipse.statet.rj.renv.core.BasicRLibLocation;
import org.eclipse.statet.rj.renv.core.DefaultLocalConfigurator;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;
import org.eclipse.statet.rj.renv.core.RLibGroup;
import org.eclipse.statet.rj.renv.core.RLibLocation;
import org.eclipse.statet.rj.rsetups.RSetup;
import org.eclipse.statet.rj.util.RVersion;

public class REnvConfigurationImpl
extends BasicREnvConfiguration
implements IREnvConfiguration,
REnvHelpConfiguration {
    private static final String PREFKEY_TYPE = "type";
    private static final String PREFKEY_NAME = "name";
    private static final String PREFKEY_RHOME_DIR = "env.r_home";
    private static final String PREFKEY_SUBARCH = "env.sub_arch";
    private static final String PREFKEY_RBITS = "env.r_bits.count";
    private static final String PREFKEY_ROS = "env.r_os.type";
    private static final String PREFKEY_RLIBS_PREFIX = "env.r_libs.";
    private static final String PREFKEY_RDOC_DIR = "env.r_doc.dir";
    private static final String PREFKEY_RSHARE_DIR = "env.r_share.dir";
    private static final String PREFKEY_RINCLUDE_DIR = "env.r_include.dir";
    private static final String PREFKEY_INDEX_DIR = "index.dir";
    private static final ImList<RLibGroup> DEFAULT_LIBS_INIT;
    private static final ImList<RLibGroup> DEFAULT_LIBS_DEFAULTS;
    private String type;
    private String nodeQualifier;
    private String checkId;
    private Preference.StringPref prefType;
    private Preference.StringPref prefName;
    private Preference.StringPref prefRHomeDirectory;
    private Preference.StringPref prefRArch;
    private Preference.IntPref prefRBits;
    private int rBits;
    private Preference.StringPref prefROS;
    private String rOS;
    private @Nullable RVersion rVersion;
    private Preference.NullableStringPref prefRDocDirectory;
    private Preference.NullableStringPref prefRShareDirectory;
    private Preference.NullableStringPref prefRIncludeDirectory;
    private Preference.NullableStringPref prefStateSharedType;
    private Preference.NullableStringPref prefStateSharedDirectory;
    private Preference.NullableStringPref prefStateSharedServer;
    private Properties sharedProperties;
    private final Object sharedPropertiesLock = new Object();
    private final PropertyChangeSupport beanSupport = new PropertyChangeSupport(this);
    private static final Pattern RHOME_OLD_PATTERN;
    private static final String RHOME_NEW_STRING;
    private static final String USERHOME_OLD_STRING;
    private static final String USERHOME_NEW_STRING;

    static {
        ImList libs;
        String id;
        Object[] groups = new RLibGroup[DEFAULT_LIB_GROUP_IDS.size()];
        int i = 0;
        while (i < groups.length) {
            id = (String)DEFAULT_LIB_GROUP_IDS.get(i);
            libs = ImCollections.emptyList();
            groups[i] = new REnvManagerLibGroup.Final(id, REnvManagerLibGroup.getLabel(id), (List<RLibLocation>)libs);
            ++i;
        }
        DEFAULT_LIBS_INIT = ImCollections.newList((Object[])groups);
        groups = new RLibGroup[DEFAULT_LIB_GROUP_IDS.size()];
        i = 0;
        while (i < groups.length) {
            id = (String)DEFAULT_LIB_GROUP_IDS.get(i);
            libs = id == "r.default" ? ImCollections.newList((Object)REnvConfigurationImpl.createDefaultLocation()) : (id == "r.site" ? ImCollections.newList((Object)new BasicRLibLocation("user", "${r_home}/site-library", null)) : ImCollections.emptyList());
            groups[i] = new REnvManagerLibGroup.Final(id, REnvManagerLibGroup.getLabel(id), (List<RLibLocation>)libs);
            ++i;
        }
        DEFAULT_LIBS_DEFAULTS = ImCollections.newList((Object[])groups);
        RHOME_OLD_PATTERN = Pattern.compile("${env_var:R_HOME}", 16);
        RHOME_NEW_STRING = Matcher.quoteReplacement("${r_home}");
        USERHOME_OLD_STRING = Matcher.quoteReplacement("~/");
        USERHOME_NEW_STRING = Matcher.quoteReplacement("${user_home}");
    }

    public static IPath getStateLocation(REnv rEnv) {
        return RCorePlugin.getInstance().getStateLocation().append("renv").append(rEnv.getId());
    }

    private static java.nio.file.Path getStateRootDirectoryPath(REnv rEnv) {
        return Paths.get(URIUtil.toURI((IPath)REnvConfigurationImpl.getStateLocation(rEnv)));
    }

    private static RLibLocation createDefaultLocation() {
        return new BasicRLibLocation("r", "${r_home}/library", null);
    }

    protected REnvConfigurationImpl(String type, ActualREnv rEnv, PreferenceAccess prefs, String key) {
        super((REnv)rEnv, REnvConfigurationImpl.getStateRootDirectoryPath(rEnv));
        this.setType(type);
        this.nodeQualifier = "org.eclipse.statet.r.core/r.environments/" + (key != null ? key : rEnv.getId());
        this.rBits = 64;
        if (prefs != null) {
            this.setRLibGroups(this.copyLibs((List<? extends RLibGroup>)DEFAULT_LIBS_DEFAULTS));
            this.load(prefs);
        } else {
            this.setRLibGroups(DEFAULT_LIBS_INIT);
        }
    }

    REnvConfigurationImpl(String type, ActualREnv rEnv, RSetup setup, PreferenceAccess prefs) {
        super((REnv)rEnv, REnvConfigurationImpl.getStateRootDirectoryPath(rEnv));
        assert (setup != null);
        if (type != "eplugin-local") {
            throw new IllegalArgumentException(type);
        }
        this.setType(type);
        this.nodeQualifier = "org.eclipse.statet.r.core/r.environments/" + rEnv.getId();
        this.setName(setup.getName());
        this.setROS(setup.getOS());
        if (SystemUtils.getLocalOs() == 1) {
            String arch = setup.getOSArch();
            if (arch == null || arch.isEmpty()) {
                arch = SystemUtils.getLocalArch();
            }
            this.setRArch(arch);
        }
        this.rBits = "x86_32".equals(setup.getOSArch()) ? 32 : 64;
        this.setRHomeDirectory(setup.getRHome());
        this.loadDefaultInstallDir();
        try {
            String versionString = setup.getRVersion();
            if (versionString != null) {
                this.rVersion = new RVersion(versionString);
            }
        }
        catch (IllegalArgumentException versionString) {
            // empty catch block
        }
        ImList libGroupIds = DEFAULT_LIB_GROUP_IDS;
        ArrayList<REnvManagerLibGroup.Final> groups = new ArrayList<REnvManagerLibGroup.Final>(libGroupIds.size());
        ArrayList<Object> libLocations = new ArrayList<Object>();
        String userHome = this.getUserHome();
        String eclipseHome = this.getInstallLocation();
        for (String id : libGroupIds) {
            List locations;
            libLocations.clear();
            String label = REnvManagerLibGroup.getLabel(id);
            if (label == null) continue;
            if (id == "r.default") {
                libLocations.add(REnvConfigurationImpl.createDefaultLocation());
                locations = null;
            } else if (id == "r.site") {
                locations = setup.getRLibsSite();
            } else if (id == "r.user") {
                locations = setup.getRLibsUser();
                try {
                    String path = "${workspace_loc}/.metadata/.r/" + this.getREnv().getId() + "/user-library";
                    IFileStore store = FileUtil.expandToLocalFileStore((String)path, null, null);
                    if (!store.fetchInfo().exists()) {
                        store.mkdir(0, null);
                    }
                    libLocations.add(new BasicRLibLocation("r", path, "Workspace Library"));
                }
                catch (Exception e) {
                    RCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.core", "An error occured when creating default R_USER 'Workspace Library'.", (Throwable)e));
                }
            } else {
                if (id != "r.common") continue;
                locations = setup.getRLibs();
            }
            if (locations != null) {
                int j = 0;
                while (j < locations.size()) {
                    String path = (String)locations.get(j);
                    if (eclipseHome != null && path.startsWith(eclipseHome)) {
                        path = "${eclipse_home}" + File.separatorChar + path.substring(eclipseHome.length());
                    } else if (userHome != null && path.startsWith(userHome)) {
                        path = "${user_home}" + File.separatorChar + path.substring(userHome.length());
                    }
                    libLocations.add(new BasicRLibLocation("eplugin", path, null));
                    ++j;
                }
            }
            groups.add(new REnvManagerLibGroup.Final(id, label, (List<RLibLocation>)ImCollections.toList(libLocations)));
        }
        this.setRLibGroups(ImCollections.toList(groups));
        if (prefs != null) {
            this.load(prefs);
        }
        this.resolvePaths();
    }

    private void setType(@Nullable String type) {
        int flags = type == "user-local" ? 5 : (type == "user-remote" ? 2 : (type == "eplugin-local" ? 5 : (type != null && type.startsWith("contrib.temp-remote") ? 2 : 0)));
        this.type = type;
        this.setFlags(flags);
    }

    private String getUserHome() {
        Path path = new Path(System.getProperty("user.home"));
        path = path.addTrailingSeparator();
        return path.toOSString();
    }

    private String getInstallLocation() {
        IPath path;
        Location installLocation = Platform.getInstallLocation();
        if (installLocation == null) {
            return null;
        }
        URL url = installLocation.getURL();
        if (url == null) {
            return null;
        }
        try {
            path = URIUtil.toPath((URI)url.toURI());
        }
        catch (URISyntaxException e) {
            return null;
        }
        if (path == null) {
            return null;
        }
        path = path.addTrailingSeparator();
        return path.toOSString();
    }

    public REnvConfigurationImpl(IREnvConfiguration config) {
        this(config.getType(), (ActualREnv)config.getREnv(), (PreferenceAccess)null, (String)null);
        this.load(config);
    }

    protected void checkPrefs(PreferenceAccess prefs) {
        String type;
        String id = this.getREnv().getId();
        if (id.equals(this.checkId)) {
            return;
        }
        this.checkId = id;
        this.prefType = new Preference.StringPref(this.nodeQualifier, PREFKEY_TYPE);
        if (this.type == null && prefs != null && (type = (String)prefs.getPreferenceValue((Preference)this.prefType)) != null) {
            this.setType(type.intern());
        }
        this.prefName = new Preference.StringPref(this.nodeQualifier, PREFKEY_NAME);
        this.prefROS = new Preference.StringPref(this.nodeQualifier, PREFKEY_ROS);
        if (this.type == "user-local") {
            this.prefRHomeDirectory = new Preference.StringPref(this.nodeQualifier, PREFKEY_RHOME_DIR);
            this.prefRArch = new Preference.StringPref(this.nodeQualifier, PREFKEY_SUBARCH);
            this.prefRBits = new Preference.IntPref(this.nodeQualifier, PREFKEY_RBITS);
            this.prefRDocDirectory = new Preference.NullableStringPref(this.nodeQualifier, PREFKEY_RDOC_DIR);
            this.prefRShareDirectory = new Preference.NullableStringPref(this.nodeQualifier, PREFKEY_RSHARE_DIR);
            this.prefRIncludeDirectory = new Preference.NullableStringPref(this.nodeQualifier, PREFKEY_RINCLUDE_DIR);
        }
        this.prefStateSharedType = new Preference.NullableStringPref(this.nodeQualifier, "State.Shared.type");
        this.prefStateSharedDirectory = new Preference.NullableStringPref(this.nodeQualifier, "State.Shared.Directory.path");
        this.prefStateSharedServer = new Preference.NullableStringPref(this.nodeQualifier, "State.Shared.Server.uri");
    }

    void upgradePref() {
        this.checkId = null;
        this.nodeQualifier = "org.eclipse.statet.r.core/r.environments/" + this.getREnv().getId();
    }

    protected void checkExistence(PreferenceAccess prefs) {
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isEditable() {
        return this.type == "user-local" || this.type == "user-remote";
    }

    @Override
    public String getPrefNodeQualifier() {
        this.checkPrefs(null);
        return this.nodeQualifier;
    }

    public void loadDefaults() {
        if (!(this instanceof IREnvConfiguration.WorkingCopy)) {
            throw new UnsupportedOperationException("No working copy");
        }
        this.setName("R");
        if (this.type == "user-local") {
            this.setRHomeDirectory("");
            this.setRLibGroups(this.copyLibs((List<? extends RLibGroup>)DEFAULT_LIBS_DEFAULTS));
        }
        if (this.isLocal()) {
            this.loadDefaultInstallDir();
        }
        this.resolvePaths();
    }

    private void loadDefaultInstallDir() {
        this.setRDocDirectory("${r_home}/doc");
        this.setRShareDirectory("${r_home}/share");
        this.setRIncludeDirectory("${r_home}/include");
    }

    public void load(IREnvConfiguration from) {
        this.setName(from.getName());
        this.setROS(from.getROS());
        if (this.isLocal()) {
            this.setRHomeDirectory(from.getRHomeDirectory());
            this.setRArch(from.getRArch());
            this.rBits = from instanceof REnvConfigurationImpl ? ((REnvConfigurationImpl)from).rBits : 64;
            this.setRDocDirectory(from.getRDocDirectory());
            this.setRShareDirectory(from.getRShareDirectory());
            this.setRIncludeDirectory(from.getRIncludeDirectory());
            this.setRLibGroups(this.copyLibs((List<? extends RLibGroup>)from.getRLibGroups()));
        }
        this.setStateSharedType(from.getStateSharedType());
        String directory = null;
        String server = null;
        switch (this.getStateSharedType()) {
            case "directory": {
                directory = from.getStateSharedDirectory();
                break;
            }
            case "server": {
                server = from.getStateSharedServer();
            }
        }
        this.setStateSharedDirectory(directory);
        this.setStateSharedServer(server);
        this.resolvePaths();
    }

    public void load(PreferenceAccess prefs) {
        this.checkPrefs(prefs);
        this.checkExistence(prefs);
        if (this.isEditable()) {
            this.setName((String)prefs.getPreferenceValue((Preference)this.prefName));
            this.setROS((String)prefs.getPreferenceValue((Preference)this.prefROS));
        }
        if (this.type == "user-local") {
            this.setRHomeDirectory((String)prefs.getPreferenceValue((Preference)this.prefRHomeDirectory));
            this.setRArch((String)prefs.getPreferenceValue((Preference)this.prefRArch));
            this.rBits = (Integer)prefs.getPreferenceValue((Preference)this.prefRBits);
            this.setRDocDirectory((String)prefs.getPreferenceValue((Preference)this.prefRDocDirectory));
            this.setRShareDirectory((String)prefs.getPreferenceValue((Preference)this.prefRShareDirectory));
            this.setRIncludeDirectory((String)prefs.getPreferenceValue((Preference)this.prefRIncludeDirectory));
        }
        if (this.isLocal()) {
            ImList libGroupIds = DEFAULT_LIB_GROUP_IDS;
            ArrayList<REnvManagerLibGroup.Final> groups = new ArrayList<REnvManagerLibGroup.Final>(libGroupIds.size());
            for (String id : libGroupIds) {
                ArrayList<Object> libs = new ArrayList<Object>();
                RLibGroup group = this.getRLibGroup(id);
                for (RLibLocation location : group.getLibLocations()) {
                    if (location.getSource() == "user") continue;
                    libs.add(location);
                }
                if (id != "r.default") {
                    String[] paths;
                    String[] stringArray = paths = (String[])prefs.getPreferenceValue((Preference)new Preference.StringArrayPref(this.nodeQualifier, PREFKEY_RLIBS_PREFIX + id, '\u001e'));
                    int n = paths.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String path = stringArray[n2];
                        BasicRLibLocation location = new BasicRLibLocation("user", path, null);
                        if (!libs.contains(location)) {
                            libs.add(location);
                        }
                        ++n2;
                    }
                }
                groups.add(new REnvManagerLibGroup.Final(id, REnvManagerLibGroup.getLabel(id), (List<RLibLocation>)ImCollections.toList(libs)));
            }
            this.setRLibGroups(ImCollections.toList(groups));
        }
        this.setStateSharedType((String)ObjectUtils.nonNullElse((Object)((String)prefs.getPreferenceValue((Preference)this.prefStateSharedType)), (Object)"directory"));
        this.setStateSharedDirectory((String)prefs.getPreferenceValue((Preference)this.prefStateSharedDirectory));
        this.setStateSharedServer((String)prefs.getPreferenceValue((Preference)this.prefStateSharedServer));
        this.resolvePaths();
    }

    protected ImList<? extends RLibGroup> copyLibs(List<? extends RLibGroup> source) {
        Object[] groups = new RLibGroup[source.size()];
        int i = 0;
        while (i < groups.length) {
            groups[i] = new REnvManagerLibGroup.Final(source.get(i));
            ++i;
        }
        return ImCollections.newList((Object[])groups);
    }

    public Map<Preference<?>, Object> deliverToPreferencesMap(Map<Preference<?>, Object> map) {
        this.checkPrefs(null);
        map.put((Preference<?>)this.prefType, this.getType());
        if (this.isEditable()) {
            map.put((Preference<?>)this.prefName, this.getName());
            map.put((Preference<?>)this.prefROS, this.getROS());
        }
        if (this.type == "user-local") {
            map.put((Preference<?>)this.prefRHomeDirectory, this.getRHomeDirectory());
            map.put((Preference<?>)this.prefRArch, this.getRArch());
            map.put((Preference<?>)this.prefRBits, this.rBits);
            map.put((Preference<?>)this.prefRDocDirectory, this.getRDocDirectory());
            map.put((Preference<?>)this.prefRShareDirectory, this.getRShareDirectory());
            map.put((Preference<?>)this.prefRIncludeDirectory, this.getRIncludeDirectory());
        }
        if (this.isLocal()) {
            ImList groups = this.getRLibGroups();
            for (RLibGroup group : groups) {
                List libraries = group.getLibLocations();
                ArrayList<String> locations = new ArrayList<String>(libraries.size());
                for (RLibLocation location : libraries) {
                    if (location.getSource() != "user") continue;
                    locations.add(location.getDirectory());
                }
                map.put((Preference<?>)new Preference.StringArrayPref(this.nodeQualifier, PREFKEY_RLIBS_PREFIX + group.getId(), '\u001e'), locations.toArray(new String[locations.size()]));
            }
        }
        map.put((Preference<?>)this.prefStateSharedType, this.getStateSharedType());
        map.put((Preference<?>)this.prefStateSharedDirectory, this.getStateSharedDirectory());
        map.put((Preference<?>)this.prefStateSharedServer, this.getStateSharedServer());
        return map;
    }

    @Override
    public Editable createWorkingCopy() {
        return new Editable(this);
    }

    public REnvConfigurationImpl getBaseConfiguration() {
        return this;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.beanSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.beanSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.beanSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.beanSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, String oldValue, String newValue) {
        this.beanSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public RVersion getRVersion() {
        return this.rVersion;
    }

    public boolean isValidRHomeLocation(IFileStore rHome) {
        IFileStore binDir = rHome.getChild("bin");
        IFileStore exeFile = null;
        switch (SystemUtils.getLocalOs()) {
            case 1: {
                exeFile = binDir.getChild("R.exe");
                break;
            }
            default: {
                exeFile = binDir.getChild("R");
            }
        }
        IFileInfo info = exeFile.fetchInfo();
        return !info.isDirectory() && info.exists();
    }

    public List<String> searchAvailableSubArchs(IFileStore rHome) {
        if (rHome != null && rHome.fetchInfo().exists()) {
            try {
                String name;
                IFileStore rHomeBinSub;
                switch (SystemUtils.getLocalOs()) {
                    case 1: {
                        rHomeBinSub = rHome.getChild("bin");
                        name = "R.exe";
                        break;
                    }
                    default: {
                        rHomeBinSub = rHome.getChild("bin").getChild("exec");
                        name = "R";
                    }
                }
                if (rHomeBinSub.fetchInfo().exists()) {
                    IFileStore[] subDirs = rHomeBinSub.childStores(0, null);
                    ArrayList<String> archs = new ArrayList<String>();
                    IFileStore[] iFileStoreArray = subDirs;
                    int n = subDirs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String arch;
                        IFileStore subDir = iFileStoreArray[n2];
                        if (subDir.getChild(name).fetchInfo().exists() && (arch = this.normalizeRArch(subDir.getName())) != null) {
                            archs.add(arch);
                        }
                        ++n2;
                    }
                    return archs;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public IStatus validate() {
        CoreException error = null;
        if (this.isLocal()) {
            IFileStore rloc = null;
            try {
                rloc = FileUtil.expandToLocalFileStore((String)this.getRHomeDirectory(), null, null);
            }
            catch (CoreException e) {
                error = e;
            }
            if (rloc == null || !this.isValidRHomeLocation(rloc)) {
                return new Status(4, "org.eclipse.statet.r.core", Messages.REnvConfiguration_Validation_error_InvalidRHome_message, (Throwable)error);
            }
        }
        return Status.OK_STATUS;
    }

    protected void setRHomeDirectory(@Nullable String directory) {
        directory = REnvConfigurationImpl.updatePathSpec(directory);
        super.setRHomeDirectory(directory);
    }

    @Override
    public String getROS() {
        return this.rOS;
    }

    protected void setROS(String type) {
        this.rOS = type;
    }

    protected void setRShareDirectory(@Nullable String directory) {
        directory = REnvConfigurationImpl.updateRDirectoryPathSpec(directory);
        super.setRShareDirectory(directory);
    }

    protected void setRIncludeDirectory(@Nullable String directory) {
        directory = REnvConfigurationImpl.updateRDirectoryPathSpec(directory);
        super.setRIncludeDirectory(directory);
    }

    protected void setRDocDirectory(@Nullable String directory) {
        directory = REnvConfigurationImpl.updateRDirectoryPathSpec(directory);
        super.setRDocDirectory(directory);
    }

    protected void setStateSharedDirectory(@Nullable String directory) {
        directory = REnvConfigurationImpl.updatePathSpec(directory);
        super.setStateSharedDirectory(directory);
    }

    @Override
    public List<String> getExecCommand(String arg1, Set<IREnvConfiguration.Exec> execTypes) throws CoreException {
        String test = arg1 != null ? arg1.trim().toUpperCase(Locale.ROOT) : "";
        IREnvConfiguration.Exec type = IREnvConfiguration.Exec.COMMON;
        if (test.equals("CMD")) {
            if (execTypes.contains((Object)IREnvConfiguration.Exec.CMD)) {
                type = IREnvConfiguration.Exec.CMD;
                arg1 = null;
            }
        } else if (execTypes.contains((Object)IREnvConfiguration.Exec.TERM)) {
            type = IREnvConfiguration.Exec.TERM;
        }
        List<String> commandLine = this.getExecCommand(type);
        if (arg1 != null) {
            commandLine.add(arg1);
        }
        return commandLine;
    }

    @Override
    public List<String> getExecCommand(IREnvConfiguration.Exec execType) throws CoreException {
        List<IFileStore> binDirs = this.getBinDirs();
        IFileStore exe = null;
        ArrayList<String> commandLine = new ArrayList<String>(2);
        switch (execType) {
            case TERM: {
                if (SystemUtils.getLocalOs() != 1) break;
                exe = this.getExisting(binDirs, "Rterm.exe");
                break;
            }
            case CMD: {
                if (SystemUtils.getLocalOs() == 1) {
                    exe = this.getExisting(binDirs, "Rcmd.exe");
                }
                if (exe != null) break;
                commandLine.add("CMD");
                break;
            }
        }
        if (exe == null) {
            exe = SystemUtils.getLocalOs() == 1 ? this.getExisting(binDirs, "R.exe") : this.getExisting(binDirs, "R");
        }
        commandLine.add(0, URIUtil.toPath((URI)exe.toURI()).toOSString());
        return commandLine;
    }

    private List<IFileStore> getBinDirs() throws CoreException {
        ArrayList<IFileStore> dirs;
        IFileStore rHomeBin;
        block12: {
            IFileStore rHomeBinArch;
            IFileStore rHome = FileUtil.expandToLocalFileStore((String)this.getRHomeDirectory(), null, null);
            rHomeBin = rHome.getChild("bin");
            Object rHomeBinSub = SystemUtils.getLocalOs() == 1 ? rHomeBin : null;
            dirs = new ArrayList<IFileStore>(4);
            String arch = this.getRArch();
            if (arch == null) {
                arch = SystemUtils.getLocalArch();
            }
            if (arch == null || rHomeBinSub == null) break block12;
            switch (arch) {
                case "x86_64": {
                    rHomeBinArch = this.getExistingChild((IFileStore)rHomeBinSub, new String[]{"x86_64", "x64"});
                    break;
                }
                case "x86_32": {
                    rHomeBinArch = this.getExistingChild((IFileStore)rHomeBinSub, new String[]{"x86", "i386", "i586", "i686"});
                    break;
                }
                default: {
                    rHomeBinArch = this.getExistingChild((IFileStore)rHomeBinSub, new String[]{arch});
                }
            }
            if (rHomeBinArch != null) {
                dirs.add(rHomeBinArch);
            }
        }
        dirs.add(rHomeBin);
        return dirs;
    }

    private IFileStore getExistingChild(IFileStore base, String ... names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            IFileStore child = base.getChild(name);
            if (child.fetchInfo().exists()) {
                return child;
            }
            ++n2;
        }
        return null;
    }

    private IFileStore getExisting(List<IFileStore> dirs, String name) {
        IFileStore file = null;
        for (IFileStore dir : dirs) {
            file = dir.getChild(name);
            if (file.fetchInfo().exists()) break;
        }
        return file;
    }

    @Override
    public Map<String, String> getEnvironmentsVariables() throws CoreException {
        try {
            DefaultLocalConfigurator setup = new DefaultLocalConfigurator((REnvConfiguration)this);
            Map envp = setup.getEnvironmentsVariables(0);
            if (((Boolean)EPreferences.getInstancePrefs().getPreferenceValue((Preference)RCorePreferenceNodes.PREF_RENV_NETWORK_USE_ECLIPSE)).booleanValue()) {
                this.configureNetwork(envp);
            }
            return envp;
        }
        catch (StatusException e) {
            throw StatusUtils.convert((StatusException)e);
        }
    }

    protected void configureNetwork(Map<String, String> envp) {
        IProxyService proxyService = RCorePlugin.getInstance().getProxyService();
        if (proxyService != null && proxyService.isProxiesEnabled()) {
            StringBuilder sb = new StringBuilder();
            String[] nonProxiedHosts = proxyService.getNonProxiedHosts();
            if (nonProxiedHosts.length > 0) {
                sb.setLength(0);
                sb.append(nonProxiedHosts[0]);
                int i = 1;
                while (i < nonProxiedHosts.length) {
                    sb.append(',');
                    sb.append(nonProxiedHosts[i]);
                    ++i;
                }
                envp.put("no_proxy", sb.toString());
            }
            if (SystemUtils.getLocalOs() == 1 && proxyService.isSystemProxiesEnabled()) {
                envp.put("R_NETWORK", "2");
            } else {
                IProxyData data = proxyService.getProxyData("HTTP");
                if (data != null && data.getHost() != null) {
                    sb.setLength(0);
                    sb.append("http://");
                    if (data.isRequiresAuthentication()) {
                        if (data.getPassword() == null || data.getPassword().isEmpty()) {
                            envp.put("http_proxy_user", "ask");
                        } else {
                            sb.append(data.getUserId() != null ? data.getUserId() : "").append(':').append(data.getPassword());
                            sb.append('@');
                        }
                    }
                    sb.append(data.getHost());
                    if (data.getPort() > 0) {
                        sb.append(':').append(data.getPort());
                    }
                    sb.append('/');
                    envp.put("http_proxy", sb.toString());
                }
                if ((data = proxyService.getProxyData("FTP")) != null && data.getHost() != null) {
                    sb.setLength(0);
                    sb.append("ftp://");
                    sb.append(data.getHost());
                    if (data.getPort() > 0) {
                        sb.append(':').append(data.getPort());
                    }
                    sb.append('/');
                    envp.put("ftp_proxy", sb.toString());
                    if (data.isRequiresAuthentication()) {
                        if (data.getUserId() != null) {
                            envp.put("ftp_proxy_user", data.getUserId());
                        }
                        if (data.getPassword() != null) {
                            envp.put("ftp_proxy_password", data.getPassword());
                        }
                    }
                }
            }
        }
    }

    private static String updatePathSpec(@Nullable String spec) {
        if (spec == null) {
            return null;
        }
        if (spec.startsWith(USERHOME_OLD_STRING)) {
            spec = String.valueOf(USERHOME_NEW_STRING) + spec.substring(1);
        }
        return spec;
    }

    private static String updateRDirectoryPathSpec(@Nullable String spec) {
        if (spec == null) {
            return null;
        }
        spec = REnvConfigurationImpl.updatePathSpec(spec);
        spec = RHOME_OLD_PATTERN.matcher(spec).replaceAll(RHOME_NEW_STRING);
        return spec;
    }

    protected @Nullable java.nio.file.Path resolvePath(String spec) throws Exception {
        IFileStore fileStore = FileUtil.expandToLocalFileStore((String)spec, null, null);
        if (fileStore != null) {
            return Paths.get(fileStore.toURI());
        }
        return null;
    }

    protected boolean equalsType(REnvConfiguration other) {
        return other instanceof REnvConfigurationImpl && this.type == ((REnvConfigurationImpl)other).type;
    }

    public static class Editable
    extends REnvConfigurationImpl
    implements IREnvConfiguration.WorkingCopy {
        public Editable(String type, ActualREnv link) {
            super(type, link, (PreferenceAccess)null, (String)null);
            this.loadDefaults();
        }

        private Editable(REnvConfigurationImpl config) {
            super(config.type, (ActualREnv)config.getREnv(), (PreferenceAccess)null, (String)null);
            this.load(config);
        }

        @Override
        public void setName(String name) {
            String oldValue = this.getName();
            super.setName(name);
            this.firePropertyChange(REnvConfigurationImpl.PREFKEY_NAME, oldValue, name);
        }

        @Override
        public void setRHomeDirectory(@Nullable String directory) {
            String oldValue = this.getRHomeDirectory();
            super.setRHomeDirectory(directory);
            this.firePropertyChange("RHomeDirectory", oldValue, this.getRHomeDirectory());
        }

        @Override
        public void setRArch(String arch) {
            String oldValue = this.getRArch();
            super.setRArch(arch);
            this.firePropertyChange("RArch", oldValue, this.getRArch());
        }

        @Override
        public void setROS(String type) {
            String oldValue = this.getROS();
            super.setROS(type);
            this.firePropertyChange("ROS", oldValue, this.getROS());
        }

        @Override
        public void setRShareDirectory(@Nullable String directory) {
            String oldValue = this.getRShareDirectory();
            super.setRShareDirectory(directory);
            this.firePropertyChange("RShareDirectory", oldValue, this.getRShareDirectory());
        }

        @Override
        public void setRIncludeDirectory(@Nullable String directory) {
            String oldValue = this.getRIncludeDirectory();
            super.setRIncludeDirectory(directory);
            this.firePropertyChange("RIncludeDirectory", oldValue, this.getRIncludeDirectory());
        }

        @Override
        public void setRDocDirectory(@Nullable String directory) {
            String oldValue = this.getRDocDirectory();
            super.setRDocDirectory(directory);
            this.firePropertyChange("RDocDirectory", oldValue, this.getRDocDirectory());
        }

        protected ImList<REnvManagerLibGroup.Editable> copyLibs(List<? extends RLibGroup> source) {
            Object[] groups = new REnvManagerLibGroup.Editable[source.size()];
            int i = 0;
            while (i < groups.length) {
                groups[i] = new REnvManagerLibGroup.Editable(source.get(i));
                ++i;
            }
            return ImCollections.newList((Object[])groups);
        }

        public ImList<REnvManagerLibGroup.Editable> getRLibGroups() {
            return super.getRLibGroups();
        }

        @Override
        public REnvManagerLibGroup.Editable getRLibGroup(String id) {
            return (REnvManagerLibGroup.Editable)super.getRLibGroup(id);
        }

        @Override
        public void setStateSharedType(String type) {
            String oldValue = this.getStateSharedType();
            super.setStateSharedType(type);
            this.firePropertyChange("stateSharedType", oldValue, this.getStateSharedType());
        }

        @Override
        public void setStateSharedDirectory(@Nullable String directory) {
            String oldValue = this.getStateSharedDirectory();
            super.setStateSharedDirectory(directory);
            this.firePropertyChange("stateSharedDirectory", oldValue, this.getStateSharedDirectory());
        }

        @Override
        public void setStateSharedServer(@Nullable String url) {
            String oldValue = this.getStateSharedServer();
            super.setStateSharedServer(url);
            this.firePropertyChange("stateSharedServer", oldValue, this.getStateSharedServer());
        }
    }
}

