/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.r.core.source.RTerminal;
import org.eclipse.statet.r.core.source.ast.Arithmetic;
import org.eclipse.statet.r.core.source.ast.Assignment;
import org.eclipse.statet.r.core.source.ast.Block;
import org.eclipse.statet.r.core.source.ast.CForLoop;
import org.eclipse.statet.r.core.source.ast.CIfElse;
import org.eclipse.statet.r.core.source.ast.CRepeatLoop;
import org.eclipse.statet.r.core.source.ast.CWhileLoop;
import org.eclipse.statet.r.core.source.ast.Dummy;
import org.eclipse.statet.r.core.source.ast.FCall;
import org.eclipse.statet.r.core.source.ast.FDef;
import org.eclipse.statet.r.core.source.ast.Group;
import org.eclipse.statet.r.core.source.ast.Help;
import org.eclipse.statet.r.core.source.ast.Logical;
import org.eclipse.statet.r.core.source.ast.Model;
import org.eclipse.statet.r.core.source.ast.NSGet;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.NumberConst;
import org.eclipse.statet.r.core.source.ast.Pipe;
import org.eclipse.statet.r.core.source.ast.Placeholder;
import org.eclipse.statet.r.core.source.ast.Power;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAstVisitor;
import org.eclipse.statet.r.core.source.ast.RParser;
import org.eclipse.statet.r.core.source.ast.Relational;
import org.eclipse.statet.r.core.source.ast.Seq;
import org.eclipse.statet.r.core.source.ast.Sign;
import org.eclipse.statet.r.core.source.ast.SourceComponent;
import org.eclipse.statet.r.core.source.ast.Special;
import org.eclipse.statet.r.core.source.ast.StringConst;
import org.eclipse.statet.r.core.source.ast.SubIndexed;
import org.eclipse.statet.r.core.source.ast.SubNamed;
import org.eclipse.statet.r.core.source.ast.Symbol;

@NonNullByDefault
final class RParserPostExprVisitor
extends RAstVisitor {
    private static final int ERROR_MASK = 0x4400000;
    private static final int WARNING_MASK = 0x2200000;
    private final RParser parser;
    private int severityInChild;

    public static void updateParentStatus(RAstNode node) {
        RAstNode rParent = node.rParent;
        if (rParent == null || (rParent.status & 0x4000000) != 0) {
            return;
        }
        int statusCode = node.getStatusCode();
        if ((statusCode & 0x4400000) != 0) {
            rParent.status |= 0x4000000;
        } else if ((statusCode & 0x2200000) != 0) {
            rParent.status |= 0x2000000;
        }
    }

    public static void clearSeverityInChildern(RAstNode node) {
        node.status &= 0xF8FFFFFF;
    }

    public RParserPostExprVisitor(RParser parser) {
        this.parser = parser;
    }

    public int check(RAstNode node) {
        this.severityInChild = 0;
        try {
            node.acceptInR(this);
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return this.severityInChild;
    }

    private void updateSeverityInChild(RAstNode node) {
        if (this.severityInChild == 0x4000000) {
            return;
        }
        int statusCode = node.getStatusCode();
        if ((statusCode & 0x4400000) != 0) {
            this.severityInChild = 0x4000000;
        } else if ((statusCode & 0x2200000) != 0) {
            this.severityInChild = 0x2000000;
        }
    }

    private void doAcceptIn(RAstNode child) throws InvocationTargetException {
        int savedSeverity = this.severityInChild;
        this.severityInChild = 0;
        child.acceptInR(this);
        int severityInChild = this.severityInChild;
        if (severityInChild != 0) {
            child.rParent.status |= severityInChild;
            this.severityInChild = Math.max(savedSeverity, severityInChild);
        } else {
            this.severityInChild = savedSeverity;
        }
    }

    private void doAccecptInChildren(RAstNode node) throws InvocationTargetException {
        int savedSeverity = this.severityInChild;
        this.severityInChild = 0;
        node.acceptInRChildren(this);
        int severityInChild = this.severityInChild;
        if (severityInChild != 0) {
            node.status |= severityInChild;
            this.severityInChild = Math.max(savedSeverity, severityInChild);
        } else {
            this.severityInChild = savedSeverity;
        }
    }

    private void markSubsequentIfStatus12(RAstNode node, int status) {
        if ((node.getStatusCode() & 0x7FFFF0) == status) {
            node.status |= 0x800000;
        }
    }

    @Override
    public void visit(SourceComponent node) {
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Block node) {
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Group node) {
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(CIfElse node) throws InvocationTargetException {
        if (node.withElse) {
            this.doAcceptIn(node.elseExpr.node);
        }
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(CForLoop node) throws InvocationTargetException {
        this.doAcceptIn(node.loopExpr.node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(CRepeatLoop node) throws InvocationTargetException {
        this.doAcceptIn(node.loopExpr.node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(CWhileLoop node) throws InvocationTargetException {
        this.doAcceptIn(node.loopExpr.node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(FCall node) throws InvocationTargetException {
        this.doAcceptIn(node.refExpr.node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(FCall.Args node) {
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(FCall.Arg node) {
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(FDef node) throws InvocationTargetException {
        this.doAcceptIn(node.expr.node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(FDef.Args node) {
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(FDef.Arg node) {
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Assignment node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Pipe node) throws InvocationTargetException {
        RAstNode target = node.getTargetChild();
        if (target.getNodeType() == NodeType.F_CALL) {
            FCall.Args args = ((FCall)target).getArgsChild();
            if (this.parser.getLangVersion() >= 2) {
                int nPlaceholder = 0;
                for (FCall.Arg arg : args.getArgChildren()) {
                    RAstNode argValue = arg.getValueChild();
                    if (argValue == null || argValue.getNodeType() != NodeType.PLACEHOLDER || argValue.getOperator(0) != RTerminal.PIPE_PLACEHOLDER) continue;
                    if (nPlaceholder++ > 0) {
                        argValue.status = 4227490;
                        continue;
                    }
                    if (!arg.hasName()) {
                        argValue.status = 4227491;
                        continue;
                    }
                    argValue.status = 0;
                    RParserPostExprVisitor.clearSeverityInChildern(arg);
                    RParserPostExprVisitor.updateParentStatus(arg.getNameChild());
                }
                if (nPlaceholder > 0) {
                    RParserPostExprVisitor.clearSeverityInChildern(args);
                    for (FCall.Arg arg : args.getArgChildren()) {
                        RParserPostExprVisitor.updateParentStatus(arg);
                    }
                    RParserPostExprVisitor.clearSeverityInChildern(target);
                    RParserPostExprVisitor.updateParentStatus(args);
                }
            }
        } else if ((target.getStatusCode() & 0x7FFFF0) != 4228016) {
            target.status = 4227504;
        }
        if (this.parser.getLangVersion() < 1) {
            this.markSubsequentIfStatus12(node.getSourceChild(), 4227858);
            this.markSubsequentIfStatus12(target, 4228016);
            this.markSubsequentIfStatus12(target, 4227504);
            if (target.getNodeType() == NodeType.F_CALL) {
                for (FCall.Arg arg : ((FCall)target).getArgsChild().getArgChildren()) {
                    RAstNode argValue = arg.getValueChild();
                    if (argValue == null || argValue.getNodeType() != NodeType.PLACEHOLDER || argValue.getOperator(0) != RTerminal.PIPE_PLACEHOLDER) continue;
                    this.markSubsequentIfStatus12(argValue, 4228880);
                }
            }
        }
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Model node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Relational node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Logical node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Arithmetic node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Power node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Seq node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Special node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Sign node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(SubIndexed node) throws InvocationTargetException {
        this.doAcceptIn(node.expr.node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(SubIndexed.Args node) {
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(SubIndexed.Arg node) {
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(SubNamed node) throws InvocationTargetException {
        this.doAcceptIn(node.expr.node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(NSGet node) throws InvocationTargetException {
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Symbol node) {
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Placeholder node) {
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(StringConst node) {
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(NumberConst node) {
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Help node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }

    @Override
    public void visit(Dummy node) throws InvocationTargetException {
        this.doAccecptInChildren(node);
        node.updateOffsets();
        this.updateSeverityInChild(node);
    }
}

