/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ltk.ui.sourceediting;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.LtkUI;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;

@NonNullByDefault
public class AnnotationPresentationConfig {
    private final int level;
    private final @Nullable String defaultImageId;
    private @Nullable Image defaultImage;
    private final @Nullable String awayImageId;
    private @Nullable Image awayImage;

    public AnnotationPresentationConfig(@Nullable String referenceType, int levelDiff, @Nullable String defaultImageId, @Nullable String awayImageId) {
        AnnotationPreference preference = EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(referenceType);
        this.level = levelDiff != Integer.MIN_VALUE ? (preference != null ? preference.getPresentationLayer() : 0) + levelDiff : 0;
        this.defaultImageId = defaultImageId;
        this.awayImageId = awayImageId;
    }

    public final int getLevel() {
        return this.level;
    }

    public final @Nullable Image getImage() {
        String imageId;
        Image image = this.defaultImage;
        if (image == null && (imageId = this.defaultImageId) != null) {
            this.defaultImage = image = LtkUI.getUIResources().getImage(imageId);
        }
        return image;
    }

    public final @Nullable Image getAwayImage() {
        String imageId;
        Image image = this.awayImage;
        if (image == null && (imageId = this.awayImageId) != null) {
            this.awayImage = image = LtkUI.getUIResources().getImage(imageId);
        }
        return image;
    }
}

