/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.dialogs.groups;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.ui.dialogs.groups.StructuredSelectionOptionsGroup;
import org.eclipse.statet.ecommons.ui.util.PixelConverter;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;

public abstract class CategorizedOptionsGroup<ItemT extends CategorizedItem>
extends StructuredSelectionOptionsGroup<TreeViewer, ItemT> {
    public String[] fCategorys;
    public ItemT[][] fCategoryChilds;

    public CategorizedOptionsGroup(boolean grabSelectionHorizontal, boolean grabVertical) {
        super(grabSelectionHorizontal, grabVertical);
    }

    @Override
    protected TreeViewer createSelectionViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, 2818);
        viewer.setLabelProvider((IBaseLabelProvider)new CategorizedItemLabelProvider());
        return viewer;
    }

    @Override
    protected GridData createSelectionGridData() {
        GridData gd = super.createSelectionGridData();
        Control control = ((TreeViewer)this.getStructuredViewer()).getControl();
        PixelConverter pixel = new PixelConverter(control);
        gd.heightHint = pixel.convertHeightInCharsToPixels(9);
        int maxWidth = 0;
        for (CategorizedItem item : this.getListModel()) {
            maxWidth = Math.max(maxWidth, pixel.convertWidthInCharsToPixels(item.getName().length()));
        }
        ScrollBar vBar = ((Scrollable)control).getVerticalBar();
        if (vBar != null) {
            maxWidth += vBar.getSize().x * 4;
        }
        gd.widthHint = maxWidth;
        return gd;
    }

    @Override
    protected IContentProvider createContentProvider() {
        return new CategorizedItemContentProvider();
    }

    @Override
    protected IDoubleClickListener createDoubleClickListener() {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null && selection.size() == 1) {
                    Object item = selection.getFirstElement();
                    if (item instanceof String) {
                        if (((TreeViewer)CategorizedOptionsGroup.this.getStructuredViewer()).getExpandedState(item)) {
                            ((TreeViewer)CategorizedOptionsGroup.this.getStructuredViewer()).collapseToLevel(item, -1);
                        } else {
                            ((TreeViewer)CategorizedOptionsGroup.this.getStructuredViewer()).expandToLevel(item, 1);
                        }
                    } else {
                        CategorizedOptionsGroup.this.handleDoubleClick(CategorizedOptionsGroup.this.getSingleItem(selection), selection);
                    }
                }
            }
        };
    }

    @Override
    public void initFields() {
        super.initFields();
        ((TreeViewer)this.getStructuredViewer()).getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TreeViewer viewer = (TreeViewer)CategorizedOptionsGroup.this.getStructuredViewer();
                if (viewer != null && UIAccess.isOkToUse((Viewer)viewer)) {
                    viewer.setSelection((ISelection)new StructuredSelection((Object)CategorizedOptionsGroup.this.fCategorys[0]));
                }
            }
        });
    }

    @Override
    public ItemT getSingleItem(IStructuredSelection selection) {
        if (selection.getFirstElement() instanceof String) {
            return null;
        }
        return (ItemT)((CategorizedItem)super.getSingleItem(selection));
    }

    public void generateListModel() {
        int i = 0;
        while (i < this.fCategorys.length) {
            int j = 0;
            while (j < this.fCategoryChilds[i].length) {
                ((CategorizedItem)this.fCategoryChilds[i][j]).setCategory(i);
                this.getListModel().add(this.fCategoryChilds[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public int getIndexOfCategory(Object category) {
        int i = 0;
        while (i < this.fCategorys.length) {
            if (this.fCategorys[i] == category) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static class CategorizedItem {
        private int fCategoryIndex;
        private final String fName;

        public CategorizedItem(String name) {
            this.fName = name;
        }

        public String getName() {
            return this.fName;
        }

        protected void setCategory(int index) {
            this.fCategoryIndex = index;
        }

        public int getCategoryIndex() {
            return this.fCategoryIndex;
        }
    }

    private class CategorizedItemContentProvider
    implements ITreeContentProvider {
        private CategorizedItemContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return CategorizedOptionsGroup.this.fCategorys;
        }

        public boolean hasChildren(Object element) {
            return element instanceof String;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof String) {
                int idx = CategorizedOptionsGroup.this.getIndexOfCategory(parentElement);
                return CategorizedOptionsGroup.this.fCategoryChilds[idx];
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof String) {
                return null;
            }
            int idx = ((CategorizedItem)element).getCategoryIndex();
            return CategorizedOptionsGroup.this.fCategorys[idx];
        }
    }

    private class CategorizedItemLabelProvider
    extends LabelProvider {
        private CategorizedItemLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            return ((CategorizedItem)element).getName();
        }
    }
}

