/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.io;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Comparator;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class FileUtils {
    private static final Path WORKING_DIRECTORY_REF_PATH = Path.of("", new String[0]);
    private static final FileVisitor<Path> DELETE_R_VISITOR = new FileVisitor<Path>(){

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (attrs.isSymbolicLink() || attrs.isOther()) {
                Files.delete(dir);
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            throw exc;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, @Nullable IOException exc) throws IOException {
            Files.delete(dir);
            return FileVisitResult.CONTINUE;
        }
    };
    private static final Comparator<Path> LAST_MODIFIED_TIME_COMPARATOR = new Comparator<Path>(){

        @Override
        public int compare(Path o1, Path o2) {
            FileTime time1 = null;
            FileTime time2 = null;
            try {
                time1 = Files.getLastModifiedTime(o1, new LinkOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                time2 = Files.getLastModifiedTime(o2, new LinkOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (time1 == null) {
                return time2 == null ? 0 : 1;
            }
            if (time2 == null) {
                return -1;
            }
            return time1.compareTo(time2);
        }
    };

    public static final Path getUserWorkingDirectory() {
        return WORKING_DIRECTORY_REF_PATH.toAbsolutePath();
    }

    public static final Path requireParent(Path path) {
        Path parent = path.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("path does not have a parent");
        }
        return parent;
    }

    public static final Path requireFileName(Path path) {
        Path fileName = path.getFileName();
        if (fileName == null) {
            throw new IllegalArgumentException("path is empty");
        }
        return fileName;
    }

    public static final boolean deleteRecursively(Path path) throws IOException {
        if (Files.notExists(path, new LinkOption[0])) {
            return false;
        }
        Files.walkFileTree(path, DELETE_R_VISITOR);
        return true;
    }

    public static final void cleanDirectory(Path path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, filter);){
            for (Path entry : stream) {
                FileUtils.deleteRecursively(entry);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static final void cleanDirectory(Path path) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (DirectoryStream<Path> entries = Files.newDirectoryStream(path);){
            for (Path entry : entries) {
                FileUtils.deleteRecursively(entry);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static final Comparator<Path> getLastModifiedTimeComparator() {
        return LAST_MODIFIED_TIME_COMPARATOR;
    }

    private FileUtils() {
    }
}

