/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.tex.r;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.statet.docmlet.tex.ui.sourceediting.TexEditingSettings;
import org.eclipse.statet.ecommons.ui.util.ImageRegistryUtil;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.redocs.tex.r.ui.editors.LtxRweaveDocumentProvider;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.LtkUIPreferences;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputerRegistry;
import org.eclipse.statet.ltk.ui.templates.WaContributionContextTypeRegistry;
import org.eclipse.statet.ltk.ui.util.CombinedPreferenceStore;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;

@NonNullByDefault
public class RedocsTexRPlugin
extends AbstractUIPlugin {
    private static final String NS = "org.eclipse.statet.redocs.tex.r";
    public static final String OBJ_LTXRWEAVE_IMAGE_ID = "org.eclipse.statet.redocs.tex.r/image/obj/LtxRweave";
    public static final String TOOL_NEW_LTXRWEAVE_IMAGE_ID = "org.eclipse.statet.redocs.tex.r/image/tool/New-LtxRweave";
    public static final String WIZBAN_NEW_LTXRWEAVE_FILE_IMAGE_ID = "org.eclipse.statet.redocs.tex.r/image/wizban/New-LtxRweaveFile";
    public static final String TEX_RWEAVE_EDITOR_NODE = "org.eclipse.statet.redocs.tex.r/rweavetex.editor/options";
    private static @Nullable RedocsTexRPlugin instance;
    private boolean started;
    private List<Disposable> disposables;
    private @Nullable LtxRweaveDocumentProvider docRDocumentProvider;
    private @Nullable IPreferenceStore editorPreferenceStore;
    private @Nullable ContextTypeRegistry codegenTemplateContextTypeRegistry;
    private @Nullable TemplateStore codegenTemplateStore;
    private @Nullable ContextTypeRegistry docTemplateContextTypeRegistry;
    private @Nullable TemplateStore docTemplateStore;
    private @Nullable ContentAssistComputerRegistry ltxRweaveEditorContentAssistRegistry;

    public static RedocsTexRPlugin getInstance() {
        return instance;
    }

    public static void log(IStatus status) {
        RedocsTexRPlugin plugin = RedocsTexRPlugin.getInstance();
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    @Deprecated
    public static void logError(int code, String message, Throwable e) {
        RedocsTexRPlugin.log((IStatus)new Status(4, NS, code, message, e));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.disposables = new ArrayList<Disposable>();
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            RedocsTexRPlugin redocsTexRPlugin = this;
            synchronized (redocsTexRPlugin) {
                this.started = false;
                this.editorPreferenceStore = null;
                this.codegenTemplateContextTypeRegistry = null;
                this.codegenTemplateStore = null;
                this.docTemplateContextTypeRegistry = null;
                this.docTemplateStore = null;
                this.ltxRweaveEditorContentAssistRegistry = null;
            }
            for (Disposable listener : this.disposables) {
                try {
                    listener.dispose();
                }
                catch (Throwable e) {
                    RedocsTexRPlugin.log((IStatus)new Status(4, NS, "Error occured while disposing a module.", e));
                }
            }
            this.disposables = null;
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        ImageRegistryUtil util = new ImageRegistryUtil((AbstractUIPlugin)this);
        util.register(OBJ_LTXRWEAVE_IMAGE_ID, "obj_16", "ltx_rweave-file.png");
        util.register(TOOL_NEW_LTXRWEAVE_IMAGE_ID, "tool_16", "new-ltx_rweave-file.png");
        util.register(WIZBAN_NEW_LTXRWEAVE_FILE_IMAGE_ID, "wizban", "new-ltx_rweave-file.png");
    }

    public synchronized LtxRweaveDocumentProvider getDocRDocumentProvider() {
        LtxRweaveDocumentProvider documentProvider = this.docRDocumentProvider;
        if (documentProvider == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            documentProvider = new LtxRweaveDocumentProvider();
            this.disposables.add(documentProvider);
            this.docRDocumentProvider = documentProvider;
        }
        return documentProvider;
    }

    public synchronized ContextTypeRegistry getCodegenTemplateContextTypeRegistry() {
        ContextTypeRegistry templateContextTypeRegistry = this.codegenTemplateContextTypeRegistry;
        if (templateContextTypeRegistry == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.codegenTemplateContextTypeRegistry = templateContextTypeRegistry = new WaContributionContextTypeRegistry("org.eclipse.statet.redocs.templates.TexRweaveCodegen");
        }
        return templateContextTypeRegistry;
    }

    public synchronized TemplateStore getCodegenTemplateStore() {
        TemplateStore templateStore = this.codegenTemplateStore;
        if (templateStore == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            templateStore = new ContributionTemplateStore(this.getCodegenTemplateContextTypeRegistry(), this.getPreferenceStore(), "codegen/CodeTemplates_store");
            try {
                templateStore.load();
            }
            catch (IOException e) {
                RedocsTexRPlugin.log((IStatus)new Status(4, NS, "An error occured when loading 'TeX+R code generation' template store.", (Throwable)e));
            }
            this.codegenTemplateStore = templateStore;
        }
        return templateStore;
    }

    public synchronized ContextTypeRegistry getDocTemplateContextTypeRegistry() {
        ContextTypeRegistry templateContextTypeRegistry = this.docTemplateContextTypeRegistry;
        if (templateContextTypeRegistry == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.docTemplateContextTypeRegistry = templateContextTypeRegistry = new WaContributionContextTypeRegistry("org.eclipse.statet.redocs.templates.TexRweaveDoc");
        }
        return templateContextTypeRegistry;
    }

    public synchronized TemplateStore getDocTemplateStore() {
        TemplateStore templateStore = this.docTemplateStore;
        if (templateStore == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            ScopedPreferenceStore prefStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.statet.redocs.tex.r/codegen");
            templateStore = new ContributionTemplateStore(this.getDocTemplateContextTypeRegistry(), (IPreferenceStore)prefStore, "DocTemplates_store");
            try {
                templateStore.load();
            }
            catch (IOException e) {
                RedocsTexRPlugin.log((IStatus)new Status(4, NS, 0, "An error occured when loading 'Tex+R document' template store.", (Throwable)e));
            }
            this.docTemplateStore = templateStore;
            if (!prefStore.contains("DocTemplates_store")) {
                this.migrateDocTemplateStore();
            }
        }
        return templateStore;
    }

    private void migrateDocTemplateStore() {
        ScopedPreferenceStore oldPrefStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.statet.r.sweave");
        if (!oldPrefStore.isDefault("org.eclipse.statet.r.sweave.templates.sweavedoc")) {
            try {
                TemplatePersistenceData[] templateDatas;
                TemplateStore oldTemplateStore = new TemplateStore((IPreferenceStore)oldPrefStore, "org.eclipse.statet.r.sweave.templates.sweavedoc");
                oldTemplateStore.load();
                TemplatePersistenceData[] templatePersistenceDataArray = templateDatas = oldTemplateStore.getTemplateData(false);
                int n = templateDatas.length;
                int n2 = 0;
                while (n2 < n) {
                    Template template;
                    TemplatePersistenceData templateData = templatePersistenceDataArray[n2];
                    if (templateData.isEnabled() && (template = templateData.getTemplate()).getContextTypeId().equals("ltx-rweave_NewSweaveDoc") && template.getName().startsWith("ltx-rweave.NewDoc:")) {
                        String templateName = template.getName().substring(18);
                        Template newTemplate = new Template("LtxRweave.NewDoc:" + templateName, template.getDescription(), "Ltx+Rweave_NewDoc", template.getPattern(), false);
                        TemplatePersistenceData defaultData = this.docTemplateStore.getTemplateData("org.eclipse.statet.redocs.templates.LtxRweave_" + templateName + "Doc");
                        if (defaultData != null) {
                            defaultData.setTemplate(newTemplate);
                        } else {
                            this.docTemplateStore.add(new TemplatePersistenceData(newTemplate, true));
                        }
                    }
                    ++n2;
                }
                this.docTemplateStore.save();
            }
            catch (Exception e) {
                RedocsTexRPlugin.log((IStatus)new Status(4, NS, 0, "An error occurred while migrating old 'Tex+R document' template store.", (Throwable)e));
            }
        }
    }

    public synchronized IPreferenceStore getEditorPreferenceStore() {
        IPreferenceStore preferenceStore = this.editorPreferenceStore;
        if (preferenceStore == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.editorPreferenceStore = preferenceStore = CombinedPreferenceStore.createStore((IPreferenceStore[])new IPreferenceStore[]{this.getPreferenceStore(), TexEditingSettings.getPreferenceStore(), RUIPlugin.getInstance().getPreferenceStore(), LtkUIPreferences.getPreferenceStore(), EditorsUI.getPreferenceStore()});
        }
        return preferenceStore;
    }

    public synchronized ContentAssistComputerRegistry getLtxRweaveEditorContentAssistRegistry() {
        ContentAssistComputerRegistry contentAssistRegistry = this.ltxRweaveEditorContentAssistRegistry;
        if (contentAssistRegistry == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            contentAssistRegistry = new ContentAssistComputerRegistry("org.eclipse.statet.redocs.contentTypes.LtxRweave", TEX_RWEAVE_EDITOR_NODE);
            this.disposables.add((Disposable)contentAssistRegistry);
            this.ltxRweaveEditorContentAssistRegistry = contentAssistRegistry;
        }
        return contentAssistRegistry;
    }
}

