/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.eval;

import org.eclipse.debug.core.model.IErrorReportingExpression;
import org.eclipse.statet.internal.r.debug.core.eval.EvaluationResult;
import org.eclipse.statet.internal.r.debug.core.model.RDebugElement;
import org.eclipse.statet.internal.r.debug.core.model.RDebugTargetImpl;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.debug.core.RValue;

@NonNullByDefault
public class EvaluationExpression
extends RDebugElement
implements IErrorReportingExpression {
    private static final @NonNull String[] NO_MESSAGES = new String[0];
    private final EvaluationResult result;

    public EvaluationExpression(EvaluationResult result) {
        super((RDebugTargetImpl)result.getThread().getDebugTarget());
        this.result = result;
        this.result.getThread().getExpressionManager().register(this);
    }

    public String getExpressionText() {
        return this.result.getExpressionText();
    }

    public EvaluationResult getResult() {
        return this.result;
    }

    public boolean hasErrors() {
        return this.result.getStatus() > 4;
    }

    public @NonNull String[] getErrorMessages() {
        ImList<String> messages;
        if (this.result.getStatus() >= 4 && (messages = this.result.getMessages()) != null) {
            return (String[])messages.toArray((Object[])new String[messages.size()]);
        }
        return NO_MESSAGES;
    }

    public @Nullable RValue getValue() {
        return this.result.getValue();
    }

    public void dispose() {
        this.result.getThread().getExpressionManager().unregister(this);
        this.result.free();
    }
}

