/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.runtime.core.util;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class MessageBuilder {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private final StringBuilder builder;

    public MessageBuilder() {
        this(128);
    }

    public MessageBuilder(int initialBufferLength) {
        this.builder = new StringBuilder(initialBufferLength);
    }

    public String bind(String message, Object binding) {
        return this.internalBind(message, null, String.valueOf(binding), null);
    }

    public String bind(String message, Object binding1, Object binding2) {
        return this.internalBind(message, null, String.valueOf(binding1), String.valueOf(binding2));
    }

    public String bind(String message, Object[] bindings) {
        return this.internalBind(message, bindings, null, null);
    }

    private String internalBind(String message, Object[] args, String argZero, String argOne) {
        if (message == null) {
            return "No message available.";
        }
        if (args == null || args.length == 0) {
            args = EMPTY_ARGS;
        }
        this.builder.setLength(0);
        int length = message.length();
        int bufLen = length + args.length * 5;
        if (argZero != null) {
            bufLen += argZero.length() - 3;
            if (argOne != null) {
                bufLen += argOne.length() - 3;
            }
        }
        this.builder.ensureCapacity(bufLen);
        int i = 0;
        while (i < length) {
            char c = message.charAt(i);
            switch (c) {
                case '{': {
                    int index = message.indexOf(125, i);
                    if (index == -1) {
                        this.builder.append(c);
                        break;
                    }
                    if (++i >= length) {
                        this.builder.append(c);
                        break;
                    }
                    int number = -1;
                    try {
                        number = Integer.parseInt(message.substring(i, index));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(e);
                    }
                    if (number == 0 && argZero != null) {
                        this.builder.append(argZero);
                    } else if (number == 1 && argOne != null) {
                        this.builder.append(argOne);
                    } else if (number >= 0 && number < args.length) {
                        this.builder.append(args[number]);
                    } else {
                        this.builder.append("<missing argument>");
                    }
                    i = index;
                    break;
                }
                case '\'': {
                    int nextIndex = i + 1;
                    if (nextIndex >= length) {
                        this.builder.append(c);
                        break;
                    }
                    char next = message.charAt(nextIndex);
                    if (next == '\'') {
                        ++i;
                        this.builder.append(c);
                        break;
                    }
                    int index = message.indexOf(39, nextIndex);
                    if (index == -1) {
                        this.builder.append(c);
                        break;
                    }
                    this.builder.append(message.substring(nextIndex, index));
                    i = index;
                    break;
                }
                default: {
                    this.builder.append(c);
                }
            }
            ++i;
        }
        return this.builder.toString();
    }
}

