/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import java.util.regex.Pattern;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

@NonNullByDefault
public class ShortedLabel {
    private static final Pattern LINEBREAK_PATTERN = Pattern.compile("\\r[\\n]?|\\n");
    private String text;
    private String checkedText;
    private final Label label;
    private String lineBreakReplacement = " ";

    public ShortedLabel(Composite parent, int style) {
        this.label = new Label(parent, style);
        this.label.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ShortedLabel.this.updateShortening();
            }
        });
    }

    public Label getControl() {
        return this.label;
    }

    public void setText(String label) {
        if (label == null) {
            throw new NullPointerException();
        }
        if (label.equals(this.text)) {
            return;
        }
        this.text = label;
        this.updateChecking();
        this.updateShortening();
    }

    public void setLineBreakReplacement(String s) {
        this.lineBreakReplacement = (String)ObjectUtils.nonNullAssert((Object)s);
        if (this.text != null) {
            this.updateChecking();
        }
    }

    private void updateChecking() {
        this.checkedText = LINEBREAK_PATTERN.matcher(this.text).replaceAll(this.lineBreakReplacement);
    }

    private void updateShortening() {
        Shorter shorter = new Shorter((Control)this.label);
        try {
            String text = shorter.shorten(this.checkedText);
            this.label.setText(text);
            this.label.setToolTipText(text == this.checkedText ? null : this.text);
        }
        finally {
            shorter.dispose();
        }
    }

    private static class Shorter {
        private static final String ELLIPSIS = " ... ";
        private static final int DRAW_FLAGS = 4;
        private final Control control;
        private GC gc;
        private int maxWidth;
        private String text;

        public Shorter(Control control) {
            this.control = control;
        }

        public void dispose() {
            GC gc = this.gc;
            if (gc != null) {
                this.gc = null;
                gc.dispose();
            }
        }

        public String shorten(String text) {
            if (text == null || text.isEmpty()) {
                return text;
            }
            if (this.gc == null) {
                this.gc = new GC((Drawable)this.control);
                this.maxWidth = this.control.getBounds().width;
            }
            if (this.gc.textExtent((String)text, (int)4).x <= this.maxWidth) {
                return text;
            }
            this.text = text;
            String shortedText = this.doShorten();
            this.text = null;
            return shortedText;
        }

        private String doShorten() {
            double avgCharWidth = this.gc.getFontMetrics().getAverageCharacterWidth();
            int textLength = this.text.length();
            int ellipsisWidth = this.gc.textExtent((String)ELLIPSIS, (int)4).x;
            int max2 = (this.maxWidth - ellipsisWidth) * 42 / 100;
            if ((double)max2 < avgCharWidth * 3.0) {
                max2 = 0;
            }
            int e = Math.max(textLength - (int)((double)max2 / avgCharWidth), 0);
            int w2 = this.measurePart2(e);
            while (w2 > max2 && e < textLength) {
                w2 = this.measurePart2(e++);
            }
            while (e > 0) {
                int test = this.measurePart2(e - 1);
                if (test > max2) break;
                --e;
                w2 = test;
            }
            int max1 = this.maxWidth - ellipsisWidth - w2;
            int s = Math.min((int)((double)max2 / avgCharWidth), textLength);
            int w1 = this.measurePart1(s);
            while (w1 > max1 && s > 3) {
                w1 = this.measurePart1(s--);
            }
            while (s < textLength) {
                int test = this.measurePart1(s + 1);
                if (test > max1) break;
                ++s;
                w1 = test;
            }
            return String.valueOf(this.text.substring(0, s)) + ELLIPSIS + this.text.substring(e, textLength);
        }

        private int measurePart1(int end) {
            return this.gc.textExtent((String)this.text.substring((int)0, (int)end), (int)4).x;
        }

        private int measurePart2(int start) {
            return this.gc.textExtent((String)this.text.substring((int)start), (int)4).x;
        }
    }
}

