/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.util;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.InputHistory;
import org.eclipse.statet.ecommons.ui.util.InputHistoryController;
import org.eclipse.statet.internal.ecommons.ui.UIMiscellanyPlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.browser.Browser;

@NonNullByDefault
public class BrowserUtils {
    private static @Nullable InputHistory<String> addressInputHistory;

    private static void appendEscapedJavascriptString(StringBuilder sb, String s) {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
    }

    public static @Nullable String getSelectedText(Browser browser) {
        Object value = browser.evaluate("if (window.getSelection) {var sel= window.getSelection();if (sel.rangeCount && sel.getRangeAt) {return sel.getRangeAt(0).toString();}return sel;}else if (document.getSelection) {return document.getSelection();}else if (document.selection) {return document.selection.createRange().text;}else {return '';}");
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public static boolean searchText(Browser browser, String text, boolean forward, boolean caseSensitive, boolean wrap) {
        StringBuilder script = new StringBuilder(50);
        script.append("return window.find(\"");
        BrowserUtils.appendEscapedJavascriptString(script, text);
        script.append("\",");
        script.append(caseSensitive);
        script.append(',');
        script.append(!forward);
        script.append(',');
        script.append(wrap);
        script.append(",false,true)");
        Object found = browser.evaluate(script.toString());
        return Boolean.TRUE.equals(found);
    }

    public static InputHistory<String> getDefaultAddressInputHistory() {
        InputHistory<String> history = addressInputHistory;
        if (history == null) {
            InputHistoryController.ForString controller = new InputHistoryController.ForString(DialogUtils.getDialogSettings((Plugin)UIMiscellanyPlugin.getInstance(), "browser"), "AddressInput.history");
            addressInputHistory = history = controller.getList();
        }
        return history;
    }

    private BrowserUtils() {
    }
}

