/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.core.model.build;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.internal.yaml.core.model.AstProblemReporter;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.ltk.issues.core.TaskIssueConfig;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.yaml.core.model.YamlCompositeSourceElement;
import org.eclipse.statet.yaml.core.model.YamlSourceElement;
import org.eclipse.statet.yaml.core.model.YamlSourceUnitModelInfo;
import org.eclipse.statet.yaml.core.model.build.YamlTaskTagReporter;
import org.eclipse.statet.yaml.core.source.ast.YamlAstNode;

@NonNullByDefault
public class YamlIssueReporter {
    private final AstProblemReporter syntaxProblemReporter = new AstProblemReporter();
    private final YamlTaskTagReporter taskReporter = new YamlTaskTagReporter();
    private @Nullable TaskIssueConfig taskIssueConfig;
    private boolean runProblems;
    private boolean runTasks;

    public void run(SourceUnit sourceUnit, YamlSourceUnitModelInfo modelInfo, SourceContent content, IssueRequestor requestor, int level) {
        YamlSourceElement element;
        this.runProblems = requestor.isInterestedInProblems("Yaml");
        this.runTasks = requestor.isInterestedInTasks();
        if (!this.runProblems && !this.runTasks) {
            return;
        }
        TaskIssueConfig taskIssueConfig = this.taskIssueConfig;
        if (taskIssueConfig == null) {
            PreferenceAccess prefs = EPreferences.getContextPrefs((IAdaptable)sourceUnit);
            taskIssueConfig = TaskIssueConfig.getConfig((PreferenceAccess)prefs);
        }
        if (this.runTasks) {
            this.taskReporter.configure(taskIssueConfig);
        }
        if ((element = modelInfo.getSourceElement()) instanceof YamlCompositeSourceElement) {
            ImList<? extends YamlSourceElement> elements = ((YamlCompositeSourceElement)element).getCompositeElements();
            for (YamlSourceElement yamlChunk : elements) {
                this.runReporters(sourceUnit, (AstNode)yamlChunk.getAdapter(AstNode.class), modelInfo, content, requestor, level);
            }
        } else {
            this.runReporters(sourceUnit, (AstNode)element.getAdapter(AstNode.class), modelInfo, content, requestor, level);
        }
    }

    private void runReporters(SourceUnit sourceUnit, YamlAstNode node, @Nullable YamlSourceUnitModelInfo modelInfo, SourceContent content, IssueRequestor requestor, int level) {
        if (this.runProblems) {
            this.syntaxProblemReporter.run(node, content, requestor);
        }
        if (this.runTasks) {
            this.taskReporter.run(sourceUnit, node, content, requestor);
        }
    }

    private void runReporters(SourceUnit sourceUnit, @Nullable AstNode node, @Nullable YamlSourceUnitModelInfo modelInfo, SourceContent content, IssueRequestor requestor, int level) {
        if (node == null) {
            return;
        }
        if (node instanceof YamlAstNode) {
            this.runReporters(sourceUnit, (YamlAstNode)node, modelInfo, content, requestor, level);
        }
    }
}

